package info.u_team.u_team_core.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_437;

public class ScreenEvents {
	
	/**
	 * Will be fired for key presses in screens after the gui key binds are handled
	 */
	public static final Event<ScreenAfterKeyPressed> AFTER_KEY_PRESSED = EventFactory.createArrayBacked(ScreenAfterKeyPressed.class, callbacks -> (screen, keyCode, scanCode, modifiers) -> {
		for (final ScreenAfterKeyPressed callback : callbacks) {
			if (callback.onKeyPressed(screen, keyCode, scanCode, modifiers)) {
				return true;
			}
		}
		return false;
	});
	
	@FunctionalInterface
	public interface ScreenAfterKeyPressed {
		
		boolean onKeyPressed(class_437 screen, int keyCode, int scanCode, int modifiers);
	}
	
}
