package info.u_team.u_team_core.api.dye;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

/**
 * Attach this to any item that can be colors. Automatically adds dye color recipes. Call {@link #addColoredItem(class_1792)}
 * to also register the item to the item color manager.
 *
 * @author HyCraftHD
 */
public interface DyeableItem {
	
	String TAG_DISPLAY = "display";
	String TAG_COLOR = "color";
	int DEFAULT_COLOR = 0xA06540;
	
	default <T extends class_1792 & DyeableItem> void addColoredItem(T item) {
		DyeableItemsRegistry.addItem(item);
	}
	
	default boolean hasColor(class_1799 stack) {
		final class_2487 compound = stack.method_7941(TAG_DISPLAY);
		return compound != null && compound.method_10573(TAG_COLOR, class_2520.field_33263);
	}
	
	default int getColor(class_1799 stack) {
		final class_2487 compound = stack.method_7941(TAG_DISPLAY);
		return compound != null && compound.method_10573(TAG_COLOR, class_2520.field_33263) ? compound.method_10550(TAG_COLOR) : getDefaultColor();
	}
	
	default void removeColor(class_1799 stack) {
		final class_2487 compound = stack.method_7941(TAG_DISPLAY);
		if (compound != null && compound.method_10545(TAG_COLOR)) {
			compound.method_10551(TAG_COLOR);
		}
	}
	
	default void setColor(class_1799 stack, int color) {
		stack.method_7911(TAG_DISPLAY).method_10569(TAG_COLOR, color);
	}
	
	default int getDefaultColor() {
		return DEFAULT_COLOR;
	}
	
	public static class_1799 colorStack(class_1799 stack, List<class_1767> dyeList) {
		if (!(stack.method_7909() instanceof DyeableItem)) {
			return class_1799.field_8037;
		}
		final DyeableItem dyeableItem = (DyeableItem) stack.method_7909();
		final class_1799 dyedStack = stack.method_7972();
		dyedStack.method_7939(1);
		
		final int[] rbgItemSum = new int[3];
		int mostIntenseChannelSum = 0;
		int colorItemSum = 0;
		
		if (dyeableItem.hasColor(dyedStack)) {
			final int color = dyeableItem.getColor(dyedStack);
			
			final float red = (color >> 16 & 255) / 255.0F;
			final float green = (color >> 8 & 255) / 255.0F;
			final float blue = (color & 255) / 255.0F;
			
			mostIntenseChannelSum = (int) (mostIntenseChannelSum + Math.max(red, Math.max(green, blue)) * 255.0F);
			
			rbgItemSum[0] = (int) (rbgItemSum[0] + red * 255.0F);
			rbgItemSum[1] = (int) (rbgItemSum[1] + green * 255.0F);
			rbgItemSum[2] = (int) (rbgItemSum[2] + blue * 255.0F);
			
			++colorItemSum;
		}
		
		for (final class_1767 dye : dyeList) {
			final float[] colorComponents = dye.method_7787();
			
			final int red = (int) (colorComponents[0] * 255.0F);
			final int green = (int) (colorComponents[1] * 255.0F);
			final int blue = (int) (colorComponents[2] * 255.0F);
			
			mostIntenseChannelSum += Math.max(red, Math.max(green, blue));
			
			rbgItemSum[0] += red;
			rbgItemSum[1] += green;
			rbgItemSum[2] += blue;
			
			++colorItemSum;
		}
		
		int red = rbgItemSum[0] / colorItemSum;
		int green = rbgItemSum[1] / colorItemSum;
		int blue = rbgItemSum[2] / colorItemSum;
		
		final float averageChannel = mostIntenseChannelSum / (float) colorItemSum; // float division
		final float mostIntenseChannel = Math.max(red, Math.max(green, blue));
		
		red = (int) (red * averageChannel / mostIntenseChannel);
		green = (int) (green * averageChannel / mostIntenseChannel);
		blue = (int) (blue * averageChannel / mostIntenseChannel);
		
		int finalColor = (red << 8) + green;
		finalColor = (finalColor << 8) + blue;
		
		dyeableItem.setColor(dyedStack, finalColor);
		return dyedStack;
	}
	
	public static class_1799 colorStackDyeItem(class_1799 stack, List<class_1769> dyeItemList) {
		return colorStack(stack, dyeItemList.stream().map(dyeItem -> dyeItem.method_7802()).collect(Collectors.toList()));
	}
}
