package info.u_team.u_team_test.test_multiloader.init;

import info.u_team.u_team_core.api.event.ClientEvents;
import info.u_team.u_team_core.util.KeyMappingUtil;
import info.u_team.u_team_test.test_multiloader.messages.TestClientToServerMessage;
import info.u_team.u_team_test.test_multiloader.screen.ButtonTestScreen;
import info.u_team.u_team_test.test_multiloader.screen.ButtonTestScreenVanilla;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class TestMultiLoaderClientEvents {
	
	private static void onEndClientTick(class_310 minecraft) {
		while (TestMultiLoaderKeyMappings.TEST_NETWORK_EXPLICIT_C2S.get().method_1436()) {
			TestMultiLoaderNetwork.NETWORK.sendToServer(new TestClientToServerMessage("Hello server"));
		}
	}
	
	private static boolean onScreenAfterKeyPressed(class_437 screen, int keyCode, int scanCode, int modifiers) {
		if (KeyMappingUtil.matches(TestMultiLoaderKeyMappings.TEST_GUI_SCREEN.get(), class_3675.method_15985(keyCode, scanCode))) {
			class_310.method_1551().method_1507(new ButtonTestScreen());
			return true;
		}
		if (KeyMappingUtil.matches(TestMultiLoaderKeyMappings.TEST_VANILLA_GUI_SCREEN.get(), class_3675.method_15985(keyCode, scanCode))) {
			class_310.method_1551().method_1507(new ButtonTestScreenVanilla());
			return true;
		}
		return false;
	}
	
	static void register() {
		ClientEvents.registerEndClientTick(TestMultiLoaderClientEvents::onEndClientTick);
		ClientEvents.registerScreenAfterKeyPressed(TestMultiLoaderClientEvents::onScreenAfterKeyPressed);
	}
	
}
