package info.u_team.u_team_test.test_multiloader.blockentity;

import info.u_team.u_team_core.api.block.MenuSyncedBlockEntity;
import info.u_team.u_team_core.api.menu.ItemSlotCreator;
import info.u_team.u_team_core.blockentity.UBlockEntity;
import info.u_team.u_team_core.util.ServiceUtil;
import info.u_team.u_team_test.test_multiloader.init.TestMultiLoaderBlockEntityTypes;
import info.u_team.u_team_test.test_multiloader.menu.TestInventoryMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public abstract class TestInventoryBlockEntity extends UBlockEntity implements MenuSyncedBlockEntity {
	
	private int cooldown, timer, value;
	
	protected TestInventoryBlockEntity(class_2338 pos, class_2680 state) {
		super(TestMultiLoaderBlockEntityTypes.TEST_INVENTORY.get(), pos, state);
	}
	
	@Override
	public void sendInitialMenuDataToClient(class_2540 buffer) {
		buffer.writeInt(value);
		buffer.writeInt(cooldown);
	}
	
	@Override
	public void handleInitialMenuDataFromServer(class_2540 buffer) {
		value = buffer.readInt();
		cooldown = buffer.readInt();
	}
	
	public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TestInventoryBlockEntity blockEntity) {
		if (blockEntity.timer < blockEntity.cooldown) {
			blockEntity.timer++;
			return;
		}
		blockEntity.timer = 0;
		blockEntity.value++;
		blockEntity.method_5431();
	}
	
	@Override
	public void saveNBT(class_2487 compound) {
		compound.method_10569("value", value);
		compound.method_10569("cooldown", cooldown);
	}
	
	@Override
	public void loadNBT(class_2487 compound) {
		value = compound.method_10550("value");
		cooldown = compound.method_10550("cooldown");
	}
	
	public int getCooldown() {
		return cooldown;
	}
	
	public int getValue() {
		return value;
	}
	
	public void setCooldown(int cooldown) {
		this.cooldown = cooldown;
	}
	
	public void setValue(int value) {
		this.value = value;
	}
	
	// Container
	
	@Override
	public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
		return new TestInventoryMenu(containerId, playerInventory, this);
	}
	
	@Override
	public class_2561 method_5476() {
		return class_2561.method_43470("Test");
	}
	
	public abstract ItemSlotCreator getSlotCreator();
	
	// Factory
	
	public interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		TestInventoryBlockEntity create(class_2338 pos, class_2680 state);
	}
}
