package info.u_team.u_team_core.util;

import java.util.Random;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_5820.class_6671;
import net.minecraft.class_6574;

/**
 * Utility methods for math
 *
 * @author HyCraftHD
 */
public class MathUtil {
	
	/**
	 * Static random instance if random numbers without specific seed are desired.
	 */
	public static final class_5819 RANDOM = class_5819.method_43047();
	
	/**
	 * Rotate a vector counter clock wise around the y axis.
	 *
	 * @param vec Vector to rotate
	 * @param angle Rotation angle
	 * @return Rotated vector
	 */
	public static class_243 rotateVectorAroundYCC(class_243 vec, double angle) {
		return rotateVectorCC(vec, new class_243(0, 1, 0), angle);
	}
	
	/**
	 * Rotate a vector counter clock wise around an axis.
	 *
	 * @param vec Vector to rotate
	 * @param axis Rotation axis
	 * @param angle Rotation angle
	 * @return Rotated vector
	 */
	public static class_243 rotateVectorCC(class_243 vec, class_243 axis, double angle) {
		final double x = vec.method_10216();
		final double y = vec.method_10214();
		final double z = vec.method_10215();
		
		final double u = axis.method_10216();
		final double v = axis.method_10214();
		final double w = axis.method_10215();
		
		final double rotationX = u * (u * x + v * y + w * z) * (1 - Math.cos(angle)) + x * Math.cos(angle) + (-w * y + v * z) * Math.sin(angle);
		final double rotationY = v * (u * x + v * y + w * z) * (1 - Math.cos(angle)) + y * Math.cos(angle) + (w * x - u * z) * Math.sin(angle);
		final double rotationZ = w * (u * x + v * y + w * z) * (1 - Math.cos(angle)) + z * Math.cos(angle) + (-v * x + u * y) * Math.sin(angle);
		return new class_243(rotationX, rotationY, rotationZ);
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive). Use this {@link #RANDOM} instance
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static int randomNumberInRange(int min, int max) {
		return randomNumberInRange(RANDOM, min, max);
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive).
	 *
	 * @param random The random instance
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static int randomNumberInRange(class_5819 random, int min, int max) {
		return random.method_43048(max - min + 1) + min;
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive). Use this {@link #RANDOM} instance
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static float randomNumberInRange(float min, float max) {
		return randomNumberInRange(RANDOM, min, max);
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive).
	 *
	 * @param random The random instance
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static float randomNumberInRange(class_5819 random, float min, float max) {
		return random.method_43057() * (max - min) + min;
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive). Use this {@link #RANDOM} instance
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static double randomNumberInRange(double min, double max) {
		return randomNumberInRange(RANDOM, min, max);
	}
	
	/**
	 * Returns a pseudo random number in range of min and max (inclusive).
	 *
	 * @param random The random instance
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @return Return a random value between min and max
	 */
	public static double randomNumberInRange(class_5819 random, double min, double max) {
		return random.method_43058() * (max - min) + min;
	}
	
	/**
	 * Returns a value between min and max
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @param value Value that should be in range
	 * @return Return a value between min and max
	 */
	public static int valueInRange(int min, int max, int value) {
		return Math.min(max, Math.max(min, value));
	}
	
	/**
	 * Returns a value between min and max
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @param value Value that should be in range
	 * @return Return a value between min and max
	 */
	public static long valueInRange(long min, long max, long value) {
		return Math.min(max, Math.max(min, value));
	}
	
	/**
	 * Returns a value between min and max
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @param value Value that should be in range
	 * @return Return a value between min and max
	 */
	public static float valueInRange(float min, float max, float value) {
		return Math.min(max, Math.max(min, value));
	}
	
	/**
	 * Returns a value between min and max
	 *
	 * @param min Minimal value (inclusive)
	 * @param max Maximal value (inclusive)
	 * @param value Value that should be in range
	 * @return Return a value between min and max
	 */
	public static double valueInRange(double min, double max, double value) {
		return Math.min(max, Math.max(min, value));
	}
	
	/**
	 * Returns the distance between x1, z1 and x2, z2
	 *
	 * @param x1 First x coordinate
	 * @param z1 First z coordinate
	 * @param x2 Second x coordinate
	 * @param z2 Second z coordinate
	 * @return The distance between these two coordinates
	 */
	public static float getPlaneDistance(int x1, int z1, int x2, int z2) {
		final int xDiff = x2 - x1;
		final int zDiff = z2 - z1;
		return class_3532.method_15355(xDiff * xDiff + zDiff * zDiff);
	}
	
	/**
	 * Wrapper around the {@link class_5819} for normal {@link Random} instances
	 *
	 * @author HyCraftHD
	 */
	public static final record RandomSourceWrapper(Random random) implements class_5819 {
		
		@Override
		public class_5819 method_38420() {
			return new class_5820(method_43055());
		}
		
		@Override
		public class_6574 method_38421() {
			return new class_6671(method_43055());
		}
		
		@Override
		public void method_43052(long seed) {
			random.setSeed(seed);
		}
		
		@Override
		public int method_43054() {
			return random.nextInt();
		}
		
		@Override
		public int method_43048(int bound) {
			return random.nextInt(bound);
		}
		
		@Override
		public long method_43055() {
			return random.nextLong();
		}
		
		@Override
		public boolean method_43056() {
			return random.nextBoolean();
		}
		
		@Override
		public float method_43057() {
			return random.nextFloat();
		}
		
		@Override
		public double method_43058() {
			return random.nextDouble();
		}
		
		@Override
		public double method_43059() {
			return random.nextGaussian();
		}
	}
}
