package info.u_team.u_team_core.intern.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.util.ResourceLocationUtil;
import net.minecraft.class_310;
import net.minecraft.class_7923;

@Mixin(value = class_310.class, priority = 1500)
abstract class MinecraftMixin {
	
	@Inject(method = "<init>", at = @At(value = "FIELD", target = "Lnet/minecraft/client/Minecraft;gameThread:Ljava/lang/Thread;", shift = At.Shift.AFTER, ordinal = 0))
	private void uteamcore$init$callRegisterEvents(CallbackInfo info) {
		class_7923.field_41167.method_42021().stream().sorted((first, second) -> {
			return ResourceLocationUtil.nameSpacedComparator().compare(first.method_29177(), second.method_29177());
		}).forEach(SetupEvents.REGISTER.invoker()::onRegister);
	}
	
	@Inject(method = "run", at = @At(value = "FIELD", target = "Lnet/minecraft/client/Minecraft;gameThread:Ljava/lang/Thread;", shift = At.Shift.AFTER, ordinal = 0))
	private void uteamcore$run$callCommonSetupEvent(CallbackInfo info) {
		SetupEvents.COMMON_SETUP.invoker().onSetup();
	}
}
