package info.u_team.u_team_core.impl.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_2902;
import info.u_team.u_team_core.api.registry.SpawnPlacementRegister;

public abstract class CommonSpawnPlacementRegister implements SpawnPlacementRegister {
	
	protected final Map<Supplier<? extends class_1299<? extends class_1308>>, Holder<?>> spawnPlacements;
	
	protected CommonSpawnPlacementRegister() {
		spawnPlacements = new HashMap<>();
	}
	
	@Override
	public <T extends class_1308> void register(Supplier<? extends class_1299<T>> supplier, class_1317.class_1319 placementType, class_2902.class_2903 heightmap, class_1317.class_4306<T> predicate) {
		spawnPlacements.put(supplier, new Holder<>(placementType, heightmap, predicate));
	}
	
	protected record Holder<T extends class_1308> (class_1317.class_1319 placementType, class_2902.class_2903 heightmap, class_1317.class_4306<T> predicate) {
	}
	
}
