package info.u_team.u_team_core.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.event.SetupEvents;
import info.u_team.u_team_core.util.CastUtil;

public class FabricCommonRegister<C> implements CommonRegister<C> {
	
	private final class_2378<C> registry;
	private final String modid;
	
	private final Map<FabricRegistryEntry<C>, Supplier<? extends C>> entries;
	private final Set<RegistryEntry<C>> entriesView;
	
	private boolean registryFrozen;
	
	FabricCommonRegister(class_5321<? extends class_2378<C>> key, String modid) {
		registry = CastUtil.uncheckedCast(class_7923.field_41167.method_10223(key.method_29177()));
		this.modid = modid;
		entries = new LinkedHashMap<>();
		entriesView = Collections.unmodifiableSet(entries.keySet());
	}
	
	@Override
	public <E extends C> FabricRegistryEntry<E> register(String name, Function<class_2960, ? extends E> function) {
		return register(name, () -> function.apply(new class_2960(modid, name)));
	}
	
	@Override
	public <E extends C> FabricRegistryEntry<E> register(String name, Supplier<? extends E> supplier) {
		if (registryFrozen) {
			throw new IllegalArgumentException("Registry is already frozen");
		}
		
		final class_2960 id = new class_2960(modid, name);
		final class_5321<C> key = class_5321.method_29179(registry.method_30517(), id);
		
		final FabricRegistryEntry<E> entry = new FabricRegistryEntry<>(id, CastUtil.uncheckedCast(key));
		if (entries.putIfAbsent(CastUtil.uncheckedCast(entry), supplier) != null) {
			throw new IllegalArgumentException("Duplicate registration " + name);
		}
		return entry;
	}
	
	@Override
	public void register() {
		SetupEvents.REGISTER.register(this::registerEntries);
	}
	
	private void registerEntries(class_5321<? extends class_2378<?>> eventKey) {
		if (eventKey.equals(registry.method_30517())) {
			registryFrozen = true;
			for (final Entry<FabricRegistryEntry<C>, Supplier<? extends C>> entry : entries.entrySet()) {
				final FabricRegistryEntry<C> registryEntry = entry.getKey();
				class_2378.method_39197(registry, registryEntry.getKey(), entry.getValue().get());
				registryEntry.updateReference(registry);
			}
		}
	}
	
	@Override
	public String getModid() {
		return modid;
	}
	
	@Override
	public class_5321<? extends class_2378<C>> getRegistryKey() {
		return registry.method_30517();
	}
	
	@Override
	public Collection<RegistryEntry<C>> getEntries() {
		return entriesView;
	}
	
	public static class FabricRegistryEntry<E> implements RegistryEntry<E> {
		
		private final class_2960 id;
		private final class_5321<E> key;
		
		private E value;
		private class_6880<E> holder;
		
		FabricRegistryEntry(class_2960 id, class_5321<E> key) {
			this.id = id;
			this.key = key;
		}
		
		void updateReference(class_2378<E> registry) {
			value = registry.method_10223(id);
			holder = registry.method_40264(key).orElse(null);
		}
		
		@Override
		public E get() {
			Objects.requireNonNull(value, () -> "Registry entry not present: " + id);
			return value;
		}
		
		@Override
		public class_2960 getId() {
			return id;
		}
		
		@Override
		public class_5321<E> getKey() {
			return key;
		}
		
		@Override
		public Optional<class_6880<E>> getHolder() {
			return Optional.ofNullable(holder);
		}
		
		@Override
		public boolean isPresent() {
			return value != null;
		}
		
	}
	
	public static class Factory implements CommonRegister.Factory {
		
		@Override
		public <C> CommonRegister<C> create(class_5321<? extends class_2378<C>> key, String modid) {
			return new FabricCommonRegister<>(key, modid);
		}
		
	}
	
}
