package info.u_team.u_team_core.blockentity;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2535;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2622;
import net.minecraft.class_2680;

/**
 * Basic implementation of {@link class_2586} with some extra data synchronization methods.
 *
 * @author HyCraftHD
 */
public abstract class UBlockEntity extends class_2586 implements SyncedBlockEntity {
	
	public UBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}
	
	@Override
	public void method_11007(class_2487 tag) {
		super.method_11007(tag);
		saveNBT(tag);
	}
	
	@Override
	public void method_11014(class_2487 tag) {
		super.method_11014(tag);
		loadNBT(tag);
	}
	
	/**
	 * Save data to disk. To mark the block entity to save data {@link #method_5431()} must be called.
	 *
	 * @param tag
	 */
	public void saveNBT(class_2487 tag) {
	}
	
	/**
	 * Reads data from disk.
	 *
	 * @param tag
	 */
	public void loadNBT(class_2487 tag) {
	}
	
	// synchronization on chunk load
	
	@Override
	public class_2487 method_16887() {
		final class_2487 tag = new class_2487();
		sendChunkLoadData(tag);
		return tag;
	}
	
	public void receiveUpdateTag(class_2487 tag) {
		handleChunkLoadData(tag);
	}
	
	// synchronization on block update
	
	@Override
	public class_2622 method_38235() {
		final class_2487 tag = new class_2487();
		sendUpdateStateData(tag);
		return class_2622.method_39026(this, blockEntity -> tag);
	}
	
	public void receiveUpdatePacket(class_2535 connection, class_2622 packet) {
		final class_2487 tag = packet.method_11290();
		handleUpdateStateData(tag == null ? new class_2487() : tag);
	}
	
	/**
	 * Calls {@link UBlockEntity#sendChangesToClient(int)} with flag 2 (send changes to client)
	 */
	public void sendChangesToClient() {
		sendChangesToClient(2);
	}
	
	/**
	 * Triggers a block update to send the data from the server to the client. For flags see here:
	 * {@link class_1937#method_8652(class_2338, class_2680, int)}
	 *
	 * @param flags Are described above
	 */
	public void sendChangesToClient(int flags) {
		final class_2680 state = method_11010();
		field_11863.method_8413(field_11867, state, state, flags);
	}
	
}

/**
 * Interface to hold synced methods
 */
interface SyncedBlockEntity {
	
	/**
	 * Data here will be send to the client side when the chunk is loaded. The data is received in
	 * {@link SyncedBlockEntity#handleChunkLoadData(CompoundNBT)}
	 *
	 * @param tag
	 */
	default void sendChunkLoadData(class_2487 tag) {
	}
	
	/**
	 * The data from the chunk load is received here. The data is send from
	 * {@link SyncedBlockEntity#sendChunkLoadData(CompoundNBT)}
	 *
	 * @param tag
	 */
	default void handleChunkLoadData(class_2487 tag) {
	}
	
	/**
	 * Data here will be send to the client side when the block is updated. The data is received in
	 * {@link SyncedBlockEntity#handleUpdateStateData(CompoundNBT)}. To trigger an update call
	 * {@link class_1937#method_8413(class_2338, class_2680, class_2680, int)} or
	 * {@link UBlockEntity#sendChangesToClient(int)}
	 *
	 * @param tag
	 */
	default void sendUpdateStateData(class_2487 tag) {
	}
	
	/**
	 * The data from the block update is received here. The data is send from
	 * {@link SyncedBlockEntity#sendUpdateStateData(CompoundNBT)}
	 *
	 * @param tag
	 */
	default void handleUpdateStateData(class_2487 tag) {
	}
	
}
