package info.u_team.u_team_core.api.registry.client;

import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_322;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_326;
import info.u_team.u_team_core.util.ServiceUtil;

public interface ColorProviderRegister {
	
	static ColorProviderRegister create() {
		return Factory.INSTANCE.create();
	}
	
	void register(BlockRegisterHandler handler);
	
	void register(ItemRegisterHandler handler);
	
	void register();
	
	static interface BlockRegisterHandler {
		
		void registerColor(Supplier<class_324> blockColors, Register<class_322, class_2248> register);
	}
	
	static interface ItemRegisterHandler {
		
		void registerColor(Supplier<class_325> itemColors, Supplier<class_324> blockColors, Register<class_326, class_1935> colorRegister);
	}
	
	static interface Register<T, E> {
		
		default void register(T color, E entry) {
			register(color, Stream.of(entry));
		}
		
		void register(T color, Stream<? extends E> entries);
	}
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		ColorProviderRegister create();
	}
}
