package info.u_team.u_team_core.api.network;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import info.u_team.u_team_core.util.ServiceUtil;

public interface NetworkHandler {
	
	static NetworkHandler create(String protocolVersion, class_2960 location) {
		return Factory.INSTANCE.create(protocolVersion, location);
	}
	
	default <M> void registerMessage(int index, Class<M> clazz, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkContext> messageConsumer) {
		registerMessage(index, clazz, encoder, decoder, messageConsumer, Optional.empty());
	}
	
	<M> void registerMessage(int index, Class<M> clazz, BiConsumer<M, class_2540> encoder, Function<class_2540, M> decoder, BiConsumer<M, NetworkContext> messageConsumer, Optional<NetworkEnvironment> handlerEnvironment);
	
	<M> void sendToPlayer(class_3222 player, M message);
	
	<M> void sendToServer(M message);
	
	String getProtocolVersion();
	
	void setProtocolAcceptor(Predicate<String> clientAcceptedVersions, Predicate<String> serverAcceptedVersions);
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		NetworkHandler create(String protocolVersion, class_2960 location);
	}
}
