package info.u_team.u_team_core.api.event;

import info.u_team.u_team_core.util.ServiceUtil;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public interface CommonEvents {
	
	static void registerSetup(SetupEvent event) {
		Handler.INSTANCE.registerSetup(event);
	}
	
	static void registerSetup(SetupEvent event, boolean forceMainThread) {
		Handler.INSTANCE.registerSetup(event, forceMainThread);
	}
	
	static void registerRegister(RegisterEvent event) {
		Handler.INSTANCE.registerRegister(event);
	}
	
	static void registerStartServerTick(StartServerTick event) {
		Handler.INSTANCE.registerStartServerTick(event);
	}
	
	static void registerEndServerTick(EndServerTick event) {
		Handler.INSTANCE.registerEndServerTick(event);
	}
	
	static void registerStartLevelTick(StartLevelTick event) {
		Handler.INSTANCE.registerStartLevelTick(event);
	}
	
	static void registerEndLevelTick(EndLevelTick event) {
		Handler.INSTANCE.registerEndLevelTick(event);
	}
	
	static void registerLevelLoad(LevelLoad event) {
		Handler.INSTANCE.registerLevelLoad(event);
	}
	
	static void registerLevelUnload(LevelUnload event) {
		Handler.INSTANCE.registerLevelUnload(event);
	}
	
	interface Handler {
		
		Handler INSTANCE = ServiceUtil.loadOne(Handler.class);
		
		default void registerSetup(SetupEvent event) {
			registerSetup(event, false);
		}
		
		void registerSetup(SetupEvent event, boolean forceMainThread);
		
		void registerRegister(RegisterEvent event);
		
		void registerStartServerTick(StartServerTick event);
		
		void registerEndServerTick(EndServerTick event);
		
		void registerStartLevelTick(StartLevelTick event);
		
		void registerEndLevelTick(EndLevelTick event);
		
		void registerLevelLoad(LevelLoad event);
		
		void registerLevelUnload(LevelUnload event);
	}
	
	@FunctionalInterface
	interface SetupEvent {
		
		void onSetup();
	}
	
	@FunctionalInterface
	public interface RegisterEvent {
		
		void onRegister(class_5321<? extends class_2378<?>> key);
	}
	
	@FunctionalInterface
	interface StartServerTick {
		
		void onStartTick(MinecraftServer server);
	}
	
	@FunctionalInterface
	interface EndServerTick {
		
		void onEndTick(MinecraftServer server);
	}
	
	@FunctionalInterface
	interface StartLevelTick {
		
		void onStartTick(class_3218 level);
	}
	
	@FunctionalInterface
	interface EndLevelTick {
		
		void onEndTick(class_3218 level);
	}
	
	@FunctionalInterface
	interface LevelLoad {
		
		void onLoad(class_3218 level);
	}
	
	@FunctionalInterface
	interface LevelUnload {
		
		void onUnload(class_3218 level);
	}
}
