package info.u_team.u_team_core.intern.command.uteamcore;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import info.u_team.u_team_core.util.CastUtil;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2512;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ItemStackInfoSubCommand {
	
	private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.stackinfo.success.";
	
	public static ArgumentBuilder<class_2168, ?> register() {
		return class_2170.method_9247("stackinfo").executes(context -> execute(context.getSource()));
	}
	
	private static int execute(class_2168 source) throws CommandSyntaxException {
		final class_1799 stack = source.method_9207().method_6047();
		final class_1792 item = stack.method_7909();
		
		source.method_9226(class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "item", createRegistryInfo(item, class_7924.field_41197)), false);
		
		if (item instanceof final class_1747 blockItem) {
			source.method_9226(class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "block", createRegistryInfo(blockItem.method_7711(), class_7924.field_41254)), false);
		}
		
		if (stack.method_7985()) {
			final class_5250 component = class_2512.method_32270(stack.method_7969()).method_27661();
			final class_2583 style = component.method_10866() //
					.method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471(SUCCESS_TRANSLATION_STRING + "copy").method_27692(class_124.field_1060))) //
					.method_10958(new class_2558(class_2558.class_2559.field_21462, component.getString()));
			component.method_10862(style);
			source.method_9226(class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "nbt", component), false);
		}
		return 0;
	}
	
	private static <T> class_2561 createRegistryInfo(T entry, class_5321<class_2378<T>> key) {
		final class_2378<T> vanillaRegistry = CastUtil.uncheckedCast(class_7923.field_41167.method_10223(key.method_29177()));
		final class_5250 component = class_2561.method_43470(vanillaRegistry.method_10221(entry).toString());
		final String className = getClassString(entry);
		component.method_27694(style -> style.method_10977(class_124.field_1075) //
				.method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43470(className).method_27692(class_124.field_1054))) //
				.method_10958(new class_2558(class_2558.class_2559.field_11745, className)));
		return component;
	}
	
	private static String getClassString(Object object) {
		return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
	}
}
