package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class UButton extends class_4185 implements WidgetRenderable, BackgroundColorProvider, TextProvider, Scalable, ScaleProvider {
	
	protected static final class_4241 EMTPY_PRESSABLE = button -> {
	};
	
	protected static final class_7841 field_40754 = class_4185.field_40754;
	
	protected static final RGBA WHITE = RGBA.WHITE;
	protected static final RGBA LIGHT_GRAY = new RGBA(0xA0A0A0FF);
	
	protected TextureProvider buttonTextureProvider;
	protected RGBA buttonColor;
	
	protected RGBA textColor;
	protected RGBA disabledTextColor;
	
	protected float scale = 1;
	
	public UButton(int x, int y, int width, int height, class_2561 text) {
		this(x, y, width, height, text, EMTPY_PRESSABLE);
	}
	
	public UButton(int x, int y, int width, int height, class_2561 text, class_4241 pressable) {
		this(x, y, width, height, text, pressable, field_40754);
	}
	
	public UButton(int x, int y, int width, int height, class_2561 text, class_4241 pressable, class_7841 narration) {
		super(x, y, width, height, text, pressable, narration);
		buttonTextureProvider = new WidgetTextureProvider(this::method_49602);
		buttonColor = WHITE;
		textColor = WHITE;
		disabledTextColor = LIGHT_GRAY;
	}
	
	public void setPressable(class_4241 pressable) {
		field_22767 = pressable;
	}
	
	public void setPressable(Runnable runnable) {
		field_22767 = button -> runnable.run();
	}
	
	public void setCreateNarration(class_7841 narration) {
		field_40755 = narration;
	}
	
	public RGBA getButtonColor() {
		return buttonColor;
	}
	
	public void setButtonColor(RGBA buttonColor) {
		this.buttonColor = buttonColor;
	}
	
	public RGBA getTextColor() {
		return textColor;
	}
	
	public void setTextColor(RGBA textColor) {
		this.textColor = textColor;
	}
	
	public RGBA getDisabledTextColor() {
		return disabledTextColor;
	}
	
	public void setDisabledTextColor(RGBA disabledTextColor) {
		this.disabledTextColor = disabledTextColor;
	}
	
	@Override
	public float getScale() {
		return scale;
	}
	
	@Override
	public void setScale(float scale) {
		this.scale = scale;
	}
	
	@Override
	public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderWidget(this, poseStack, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderWidgetTexture(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderButtonLikeTexture(this, buttonTextureProvider, poseStack, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
	}
	
	@Override
	public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderText(this, poseStack, mouseX, mouseY, partialTick);
	}
	
	@Override
	public RGBA getCurrentBackgroundColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return buttonColor;
	}
	
	@Override
	public class_2561 getCurrentText() {
		return method_25369();
	}
	
	@Override
	public RGBA getCurrentTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return field_22763 ? textColor : disabledTextColor;
	}
	
	@Override
	public float getCurrentScale(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return scale;
	}
	
}
