package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;

public class ScalableEditBox extends UEditBox implements Scalable, ScaleProvider {
	
	protected float scale;
	
	public ScalableEditBox(class_327 font, int x, int y, int width, int height, UEditBox previousEditBox, class_2561 title, float scale) {
		super(font, x, y, width, height, previousEditBox, title);
		this.scale = scale;
	}
	
	@Override
	public float getScale() {
		return scale;
	}
	
	@Override
	public void setScale(float scale) {
		this.scale = scale;
	}
	
	@Override
	public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		final float currentScale = getCurrentScale(poseStack, mouseX, mouseY, partialTick);
		final float positionFactor = 1 / scale;
		
		poseStack.method_22903();
		poseStack.method_22905(currentScale, currentScale, 0);
		
		final RGBA currentTextColor = WidgetUtil.respectWidgetAlpha(this, getCurrentTextColor(poseStack, mouseX, mouseY, partialTick));
		
		final String currentText = field_2105.method_27523(field_2092.substring(field_2103), (int) (method_1859() * positionFactor));
		
		final int cursorOffset = field_2102 - field_2103;
		final int selectionOffset = Math.min(field_2101 - field_2103, currentText.length());
		
		final boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
		final boolean shouldCursorBlink = method_25370() && field_2107 / 6 % 2 == 0 && isCursorInText;
		final boolean isCursorInTheMiddle = field_2102 < field_2092.length() || field_2092.length() >= field_2108;
		
		final int xOffset = (int) ((field_2095 ? field_22760 + 4 : field_22760) * positionFactor);
		final int yOffset = (int) ((field_2095 ? field_22761 + (field_22759 - 8 * currentScale) / 2 : field_22761) * positionFactor);
		
		int leftRenderedTextX = xOffset;
		
		if (!currentText.isEmpty()) {
			final String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
			leftRenderedTextX = field_2105.method_27517(poseStack, field_2099.apply(firstTextPart, field_2103), xOffset, yOffset, currentTextColor.getColorARGB());
		}
		
		int rightRenderedTextX = leftRenderedTextX;
		
		if (!isCursorInText) {
			rightRenderedTextX = cursorOffset > 0 ? (int) (xOffset + (field_22758 * positionFactor)) : xOffset;
		} else if (isCursorInTheMiddle) {
			rightRenderedTextX = leftRenderedTextX - 1;
			--leftRenderedTextX;
		}
		
		if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
			field_2105.method_27517(poseStack, field_2099.apply(currentText.substring(cursorOffset), field_2102), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
		}
		
		if (field_41100 != null && currentText.isEmpty() && !method_25370()) {
			field_2105.method_30881(poseStack, field_41100, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha(this, getCurrentHintTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
		}
		
		if (!isCursorInTheMiddle && field_2106 != null) {
			field_2105.method_1720(poseStack, field_2106, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha(this, getCurrentSuggestionTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
		}
		
		if (shouldCursorBlink) {
			if (isCursorInTheMiddle) {
				class_332.method_25294(poseStack, rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha(this, getCurrentCursorColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
			} else {
				field_2105.method_1720(poseStack, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
			}
		}
		
		poseStack.method_22909();
		
		if (selectionOffset != cursorOffset) {
			final int selectedX = xOffset + field_2105.method_1727(currentText.substring(0, selectionOffset));
			method_1886(poseStack, (int) (rightRenderedTextX * currentScale), (int) ((yOffset - 1) * currentScale), (int) ((selectedX - 1) * currentScale), (int) ((yOffset + 1 + 9) * currentScale));
		}
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (field_22763 && field_22764) {
			if (method_25351(button)) {
				final boolean clicked = method_25361(mouseX, mouseY);
				
				if (field_2096) {
					method_25365(clicked);
				}
				
				if (method_25370() && clicked) {
					int clickOffset = class_3532.method_15357(mouseX) - field_22760;
					if (field_2095) {
						clickOffset -= 4;
					}
					
					clickOffset /= getCurrentScale();
					
					final String currentText = field_2105.method_27523(field_2092.substring(field_2103), (int) (method_1859() * 1 / getCurrentScale()));
					method_1883(field_2105.method_27523(currentText, clickOffset).length() + field_2103);
					return true;
				}
			}
		}
		return false;
	}
	
	@Override
	public void method_1884(int position) {
		final int valueLength = field_2092.length();
		
		field_2101 = class_3532.method_15340(position, 0, valueLength);
		
		if (field_2105 != null) {
			if (field_2103 > valueLength) {
				field_2103 = valueLength;
			}
			
			final int scaledInnerWidth = (int) (method_1859() * 1 / getCurrentScale());
			
			final String currentText = field_2105.method_27523(field_2092.substring(field_2103), scaledInnerWidth);
			final int offset = currentText.length() + field_2103;
			if (field_2101 == field_2103) {
				field_2103 -= field_2105.method_27524(field_2092, scaledInnerWidth, true).length();
			}
			
			if (field_2101 > offset) {
				field_2103 += field_2101 - offset;
			} else if (field_2101 <= field_2103) {
				field_2103 -= field_2103 - field_2101;
			}
			
			field_2103 = class_3532.method_15340(field_2103, 0, valueLength);
		}
	}
	
	@Override
	public float getCurrentScale(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return getCurrentScale();
	}
	
	public float getCurrentScale() {
		return scale;
	}
}
