package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;

public class ImageButton extends UButton {
	
	protected class_2960 image;
	
	protected RGBA imageColor;
	
	public ImageButton(int x, int y, int width, int height, class_2960 image) {
		this(x, y, width, height, image, EMTPY_PRESSABLE);
	}
	
	public ImageButton(int x, int y, int width, int height, class_2960 image, class_4241 pessable) {
		super(x, y, width, height, class_2561.method_43473(), pessable);
		this.image = image;
		imageColor = WHITE;
	}
	
	public class_2960 getImage() {
		return image;
	}
	
	public void setImage(class_2960 image) {
		this.image = image;
	}
	
	public RGBA getImageColor() {
		return imageColor;
	}
	
	public void setImageColor(RGBA imageColor) {
		this.imageColor = imageColor;
	}
	
	@Override
	public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		final class_2960 image = getCurrentImage(poseStack, mouseX, mouseY, partialTick);
		final RGBA color = WidgetUtil.respectWidgetAlpha(this, getCurrentImageColor(poseStack, mouseX, mouseY, partialTick));
		
		RenderUtil.drawTexturedQuad(poseStack, field_22760 + 2, field_22760 + field_22758 - 2, field_22761 + 2, field_22761 + field_22759 - 2, 0, 1, 0, 1, 0, image, color);
	}
	
	public class_2960 getCurrentImage(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return image;
	}
	
	public RGBA getCurrentImageColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return imageColor;
	}
}
