package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import com.google.common.collect.Streams;

import info.u_team.u_team_core.util.ServiceUtil;

public interface CommonRegister<R> extends Iterable<RegistryEntry<R>> {
	
	static <C> CommonRegister<C> create(class_5321<? extends class_2378<C>> key, String modid) {
		return Factory.INSTANCE.create(key, modid);
	}
	
	<E extends R> RegistryEntry<E> register(String name, Function<class_2960, ? extends E> function);
	
	<E extends R> RegistryEntry<E> register(String name, Supplier<? extends E> supplier);
	
	void register();
	
	String getModid();
	
	class_5321<? extends class_2378<R>> getRegistryKey();
	
	Collection<RegistryEntry<R>> getEntries();
	
	@Override
	default Iterator<RegistryEntry<R>> iterator() {
		return getEntries().iterator();
	}
	
	default Iterable<R> entryIterable() {
		return () -> Streams.stream(this).map(RegistryEntry::get).iterator();
	}
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.load(Factory.class);
		
		<C> CommonRegister<C> create(class_5321<? extends class_2378<C>> key, String modid);
	}
	
}
