package info.u_team.u_team_core.api.registry;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.util.ServiceUtil;

public interface BlockRegister extends Iterable<RegistryEntry<class_2248>> {
	
	static BlockRegister create(String modid) {
		return Factory.INSTANCE.create(modid);
	}
	
	<B extends class_2248 & BlockItemProvider, I extends class_1792> BlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier);
	
	<B extends class_2248, I extends class_1792> BlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<class_2248, ? extends I> itemFunction);
	
	<B extends class_2248, I extends class_1792> BlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier);
	
	<B extends class_2248> RegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier);
	
	void register();
	
	String getModid();
	
	Iterable<class_2248> blockIterable();
	
	Iterable<class_1792> itemIterable();
	
	CommonRegister<class_2248> getBlockRegister();
	
	CommonRegister<class_1792> getItemRegister();
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.load(Factory.class);
		
		BlockRegister create(String modid);
	}
	
}
