/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class WidgetUtil {
    private static final String ELLIPSIS = "...";

    public static <T extends class_339 & BackgroundColorProvider> void renderWidget(T widget, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.enableDepthTest();
        ((WidgetRenderable)widget).renderWidgetTexture(poseStack, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderBackground(poseStack, mouseX, mouseY, partialTick);
        ((PerspectiveRenderable)widget).renderForeground(poseStack, mouseX, mouseY, partialTick);
        if (widget instanceof TooltipRenderable) {
            TooltipRenderable tooltipRenderable = (TooltipRenderable)widget;
            WidgetUtil.renderCustomTooltipForWidget(tooltipRenderable, poseStack, mouseX, mouseY, partialTick);
        }
    }

    public static <T extends class_339> void renderButtonLikeTexture(T widget, TextureProvider textureProvider, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RGBA color = WidgetUtil.respectWidgetAlpha(widget, ((BackgroundColorProvider)widget).getCurrentBackgroundColor(poseStack, mouseY, mouseY, partialTick));
        RenderUtil.drawContinuousTexturedBox(poseStack, widget.method_46426(), widget.method_46427(), textureProvider.getU(), textureProvider.getV(), widget.method_25368(), widget.method_25364(), textureProvider.getWidth(), textureProvider.getHeight(), 2, 3, 2, 2, 0.0f, textureProvider.getTexture(), color);
    }

    public static <T extends class_339> void renderText(T widget, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        float scale;
        class_327 font = ((TextSettingsProvider)widget).getCurrentTextFont();
        TextSettingsProvider.TextRenderType renderType = ((TextSettingsProvider)widget).getCurrentTextRenderType();
        class_2561 message = ((TextProvider)widget).getCurrentText();
        RGBA color = WidgetUtil.respectWidgetAlpha(widget, ((TextSettingsProvider)widget).getCurrentTextColor(poseStack, mouseX, mouseY, partialTick));
        if (widget instanceof ScaleProvider) {
            ScaleProvider scaleProvider = (ScaleProvider)widget;
            scale = scaleProvider.getCurrentScale(poseStack, mouseY, mouseY, partialTick);
        } else {
            scale = 1.0f;
        }
        if (message == class_5244.field_39003) {
            return;
        }
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, 0.0f);
        if (renderType == TextSettingsProvider.TextRenderType.ELLIPSIS) {
            WidgetUtil.renderTextWithCutoff(widget, font, message, color, scale, poseStack, mouseX, mouseY, partialTick);
        } else if (renderType == TextSettingsProvider.TextRenderType.SCROLLING) {
            WidgetUtil.renderTextWithScrolling(widget, font, message, color, scale, poseStack, mouseX, mouseY, partialTick);
        }
        poseStack.method_22909();
    }

    private static void renderTextWithScrolling(class_339 widget, class_327 font, class_2561 message, RGBA color, float scale, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.method_25368() - 6;
        int messageWidth = class_3532.method_15386((float)(scale * (float)font.method_27525((class_5348)message)));
        float yStart = (float)(widget.method_46427() + class_3532.method_15386((float)((float)widget.method_25364() - 9.0f * scale)) / 2 + 1) * positionFactor;
        if (messageWidth > maxWidth) {
            int difference = messageWidth - maxWidth;
            double d0 = (double)class_156.method_658() / 1000.0;
            double d1 = Math.max((double)difference * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = class_3532.method_16436((double)d2, (double)0.0, (double)difference);
            float xStart = (float)(widget.method_46426() + 3 - (int)d3) * positionFactor;
            class_332.method_44379((int)(widget.method_46426() + 3), (int)widget.method_46427(), (int)(widget.method_46426() + widget.method_25368() - 3), (int)(widget.method_46427() + widget.method_25364()));
            font.method_30881(poseStack, message, xStart, yStart, color.getColorARGB());
            class_332.method_44380();
        } else {
            float xStart = (float)(widget.method_46426() + widget.method_25368() / 2 - messageWidth / 2) * positionFactor;
            font.method_30881(poseStack, message, xStart, yStart, color.getColorARGB());
        }
    }

    private static void renderTextWithCutoff(class_339 widget, class_327 font, class_2561 message, RGBA color, float scale, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        float positionFactor = 1.0f / scale;
        int maxWidth = widget.method_25368() - 6;
        int messageWidth = class_3532.method_15386((float)(scale * (float)font.method_27525((class_5348)message)));
        int ellipsisWidth = class_3532.method_15386((float)(scale * (float)font.method_1727(ELLIPSIS)));
        if (messageWidth > maxWidth && messageWidth > ellipsisWidth) {
            message = class_2561.method_43470((String)(font.method_1714((class_5348)message, class_3532.method_15375((float)((float)maxWidth * positionFactor)) - ellipsisWidth).getString() + ELLIPSIS));
            messageWidth = maxWidth;
        }
        float xStart = (float)(widget.method_46426() + widget.method_25368() / 2 - messageWidth / 2) * positionFactor;
        float yStart = (float)(widget.method_46427() + class_3532.method_15386((float)((float)widget.method_25364() - 9.0f * scale)) / 2 + 1) * positionFactor;
        font.method_30881(poseStack, message, xStart, yStart, color.getColorARGB());
    }

    public static RGBA respectWidgetAlpha(class_339 widget, RGBA color) {
        return color.setAlphaComponent(color.getAlphaComponent() * class_3532.method_15363((float)widget.field_22765, (float)0.0f, (float)1.0f));
    }

    public static void renderCustomTooltipForWidget(TooltipRenderable renderable, class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 400.0f);
        renderable.renderTooltip(poseStack, mouseX, mouseY, partialTick);
        poseStack.method_22909();
    }
}

