/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.internal.shade.net.hycrafthd.update_checker;

import info.u_team.u_team_core.internal.shade.net.hycrafthd.update_checker.Version;
import info.u_team.u_team_core.internal.shade.net.minecraftforge.fml.VersionChecker;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class UpdateChecker {
    private static final Map<Mod, VersionChecker.ModInfo> modMap = new LinkedHashMap<Mod, VersionChecker.ModInfo>();

    public static void check(String minecraftVersion, List<Mod> mods, Function<String, Version<?>> versionMapper) {
        for (Mod mod : mods) {
            try {
                modMap.put(mod, new VersionChecker.ModInfo(mod.modid, mod.currentVersion, new URL(mod.updateUrl)));
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException("Update url is malformed", ex);
            }
        }
        VersionChecker.startVersionCheck(modMap.values(), minecraftVersion, versionMapper);
    }

    public static Result result(Mod mod) {
        VersionChecker.CheckResult result = VersionChecker.getResult(modMap.get(mod));
        return new Result(result.status(), result.target(), result.changes(), result.url());
    }

    public record Mod(String modid, String currentVersion, String updateUrl) {
    }

    public record Result(VersionChecker.Status status, Version<?> target, Map<Version<?>, String> changes, String url) {
    }
}

