/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_5481;

public class UEditBox
extends class_342
implements RenderTickable,
PerspectiveRenderable,
BackgroundColorProvider,
TextSettingsProvider {
    protected static final RGBA BLACK = RGBA.BLACK;
    protected static final RGBA WHITE = RGBA.WHITE;
    protected static final RGBA LIGHT_GRAY = new RGBA(-522133249);
    protected static final RGBA LIGHTER_GRAY = new RGBA(-791621377);
    protected static final RGBA GRAY = new RGBA(-1600085761);
    protected static final RGBA DARKER_GRAY = new RGBA(-2139062017);
    protected static final RGBA DARK_GRAY = new RGBA(0x707070FF);
    protected RGBA backgroundFrameColor;
    protected RGBA unfocusedBackgroundFrameColor;
    protected RGBA backgroundColor;
    protected RGBA textColor;
    protected RGBA disabledTextColor;
    protected RGBA hintTextColor;
    protected RGBA suggestionTextColor;
    protected RGBA cursorColor;

    public UEditBox(class_327 font, int x, int y, int width, int height, UEditBox previousEditBox, class_2561 title) {
        super(font, x, y, width, height, title);
        this.setPreviousText(previousEditBox);
        this.backgroundFrameColor = WHITE;
        this.unfocusedBackgroundFrameColor = GRAY;
        this.backgroundColor = BLACK;
        this.textColor = LIGHT_GRAY;
        this.disabledTextColor = DARK_GRAY;
        this.hintTextColor = LIGHT_GRAY;
        this.suggestionTextColor = DARKER_GRAY;
        this.cursorColor = LIGHTER_GRAY;
    }

    public RGBA getBackgroundFrameColor() {
        return this.backgroundFrameColor;
    }

    public void setBackgroundFrameColor(RGBA backgroundFrameColor) {
        this.backgroundFrameColor = backgroundFrameColor;
    }

    public RGBA getUnfocusedBackgroundFrameColor() {
        return this.unfocusedBackgroundFrameColor;
    }

    public void setUnfocusedBackgroundFrameColor(RGBA unfocusedBackgroundFrameColor) {
        this.unfocusedBackgroundFrameColor = unfocusedBackgroundFrameColor;
    }

    public RGBA getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(RGBA backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public RGBA getTextColor() {
        return this.textColor;
    }

    public void setTextColor(RGBA textColor) {
        this.textColor = textColor;
    }

    public RGBA getDisabledTextColor() {
        return this.disabledTextColor;
    }

    public void setDisabledTextColor(RGBA disabledTextColor) {
        this.disabledTextColor = disabledTextColor;
    }

    public RGBA getHintTextColor() {
        return this.hintTextColor;
    }

    public void setHintTextColor(RGBA hintTextColor) {
        this.hintTextColor = hintTextColor;
    }

    public RGBA getSuggestionTextColor() {
        return this.suggestionTextColor;
    }

    public void setSuggestionTextColor(RGBA suggestionTextColor) {
        this.suggestionTextColor = suggestionTextColor;
    }

    public RGBA getCursorColor() {
        return this.cursorColor;
    }

    public void setCursorColor(RGBA cursorColor) {
        this.cursorColor = cursorColor;
    }

    public void method_1868(int color) {
        super.method_1868(color);
        this.setTextColor(RGBA.fromARGB(color));
    }

    public void method_1860(int color) {
        super.method_1860(color);
        this.setDisabledTextColor(RGBA.fromARGB(color));
    }

    public void setPreviousText(UEditBox textField) {
        if (textField != null) {
            this.field_2092 = textField.field_2092;
            this.field_2108 = textField.field_2108;
            this.field_2103 = textField.field_2103;
            this.field_2102 = textField.field_2102;
            this.field_2101 = textField.field_2101;
        }
    }

    @Override
    public void renderTick() {
        this.method_1865();
    }

    public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(poseStack, mouseX, mouseY, partialTick);
        this.renderForeground(poseStack, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.field_2095) {
            UEditBox.method_25294((class_4587)poseStack, (int)(this.field_22760 - 1), (int)(this.field_22761 - 1), (int)(this.field_22760 + this.field_22758 + 1), (int)(this.field_22761 + this.field_22759 + 1), (int)WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentBackgroundFrameColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
            UEditBox.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentBackgroundColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
    }

    @Override
    public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        RGBA currentTextColor = WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentTextColor(poseStack, mouseX, mouseY, partialTick));
        String currentText = this.field_2105.method_27523(this.field_2092.substring(this.field_2103), this.method_1859());
        int cursorOffset = this.field_2102 - this.field_2103;
        int selectionOffset = Math.min(this.field_2101 - this.field_2103, currentText.length());
        boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
        boolean shouldCursorBlink = this.method_25370() && this.field_2107 / 6 % 2 == 0 && isCursorInText;
        boolean isCursorInTheMiddle = this.field_2102 < this.field_2092.length() || this.field_2092.length() >= this.field_2108;
        int xOffset = this.field_2095 ? this.field_22760 + 4 : this.field_22760;
        int yOffset = this.field_2095 ? this.field_22761 + (this.field_22759 - 8) / 2 : this.field_22761;
        int leftRenderedTextX = xOffset;
        if (!currentText.isEmpty()) {
            String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
            leftRenderedTextX = this.field_2105.method_27517(poseStack, (class_5481)this.field_2099.apply(firstTextPart, this.field_2103), (float)xOffset, (float)yOffset, currentTextColor.getColorARGB());
        }
        int rightRenderedTextX = leftRenderedTextX;
        if (!isCursorInText) {
            rightRenderedTextX = cursorOffset > 0 ? xOffset + this.field_22758 : xOffset;
        } else if (isCursorInTheMiddle) {
            rightRenderedTextX = leftRenderedTextX - 1;
            --leftRenderedTextX;
        }
        if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
            this.field_2105.method_27517(poseStack, (class_5481)this.field_2099.apply(currentText.substring(cursorOffset), this.field_2102), (float)leftRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
        }
        if (this.field_41100 != null && currentText.isEmpty() && !this.method_25370()) {
            this.field_2105.method_30881(poseStack, this.field_41100, (float)leftRenderedTextX, (float)yOffset, WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentHintTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (!isCursorInTheMiddle && this.field_2106 != null) {
            this.field_2105.method_1720(poseStack, this.field_2106, (float)(rightRenderedTextX - 1), (float)yOffset, WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentSuggestionTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
        }
        if (shouldCursorBlink) {
            if (isCursorInTheMiddle) {
                class_332.method_25294((class_4587)poseStack, (int)rightRenderedTextX, (int)(yOffset - 1), (int)(rightRenderedTextX + 1), (int)(yOffset + 1 + 9), (int)WidgetUtil.respectWidgetAlpha((class_339)this, this.getCurrentCursorColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
            } else {
                this.field_2105.method_1720(poseStack, "_", (float)rightRenderedTextX, (float)yOffset, currentTextColor.getColorARGB());
            }
        }
        if (selectionOffset != cursorOffset) {
            int selectedX = xOffset + this.field_2105.method_1727(currentText.substring(0, selectionOffset));
            this.method_1886(poseStack, rightRenderedTextX, yOffset - 1, selectedX - 1, yOffset + 1 + 9);
        }
    }

    @Override
    public RGBA getCurrentBackgroundColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.backgroundColor;
    }

    public RGBA getCurrentBackgroundFrameColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.method_25370() ? this.backgroundFrameColor : this.unfocusedBackgroundFrameColor;
    }

    @Override
    public RGBA getCurrentTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.field_2094 ? this.textColor : this.disabledTextColor;
    }

    public RGBA getCurrentHintTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.hintTextColor;
    }

    public RGBA getCurrentSuggestionTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.suggestionTextColor;
    }

    public RGBA getCurrentCursorColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
        return this.cursorColor;
    }
}

