/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.factory;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import info.u_team.u_team_core.api.registry.BlockRegister;
import info.u_team.u_team_core.api.registry.BlockRegistryEntry;
import info.u_team.u_team_core.api.registry.CommonRegister;
import info.u_team.u_team_core.api.registry.RegistryEntry;
import info.u_team.u_team_core.factory.FabricCommonRegister;
import info.u_team.u_team_core.util.CastUtil;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class FabricBlockRegister
implements BlockRegister {
    private final FabricCommonRegister<class_2248> blocks;
    private final FabricCommonRegister<class_1792> items;
    private final Map<FabricCommonRegister.FabricRegistryEntry<? extends class_2248>, FabricCommonRegister.FabricRegistryEntry<? extends class_1792>> blockToItemsMap;

    FabricBlockRegister(String modid) {
        this.blocks = new FabricCommonRegister(class_7924.field_41254, modid);
        this.items = new FabricCommonRegister(class_7924.field_41197, modid);
        this.blockToItemsMap = new LinkedHashMap<FabricCommonRegister.FabricRegistryEntry<? extends class_2248>, FabricCommonRegister.FabricRegistryEntry<? extends class_1792>>();
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> supplier) {
        RegistryEntry block = this.blocks.register(name, supplier);
        class_2960 id = new class_2960(this.items.getModid(), name);
        class_5321 key = (class_5321)CastUtil.uncheckedCast(class_5321.method_29179(this.items.getRegistryKey(), (class_2960)id));
        FabricCommonRegister.FabricRegistryEntry item = new FabricCommonRegister.FabricRegistryEntry(id, key);
        this.blockToItemsMap.put((FabricCommonRegister.FabricRegistryEntry<? extends class_2248>)block, item);
        return new FabricBlockRegistryEntry(block, item);
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Function<class_2248, ? extends I> itemFunction) {
        return this.register(name, (Supplier)blockSupplier, () -> (class_1792)itemFunction.apply((class_2248)class_7923.field_41175.method_10223(new class_2960(this.blocks.getModid(), name))));
    }

    public <B extends class_2248, I extends class_1792> FabricBlockRegistryEntry<B, I> register(String name, Supplier<? extends B> blockSupplier, Supplier<? extends I> itemSupplier) {
        RegistryEntry block = this.blocks.register(name, blockSupplier);
        RegistryEntry item = this.items.register(name, itemSupplier);
        return new FabricBlockRegistryEntry(block, item);
    }

    public <B extends class_2248> FabricCommonRegister.FabricRegistryEntry<B> registerBlock(String name, Supplier<? extends B> supplier) {
        return this.blocks.register(name, supplier);
    }

    @Override
    public void register() {
        this.blocks.register();
        this.items.register();
        this.blockToItemsMap.forEach((? super K blockEntry, ? super V itemEntry) -> {
            BlockItemProvider blockItemProvider;
            class_1792 blockItem;
            class_2248 block = (class_2248)blockEntry.get();
            if (block instanceof BlockItemProvider && (blockItem = (blockItemProvider = (BlockItemProvider)block).blockItem()) != null) {
                class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)itemEntry.getId(), (Object)blockItem);
                itemEntry.updateReference((class_2378)CastUtil.uncheckedCast(class_7923.field_41178));
            }
        });
    }

    @Override
    public String getModid() {
        return this.blocks.getModid();
    }

    @Override
    public Iterator<RegistryEntry<class_2248>> iterator() {
        return this.blocks.iterator();
    }

    @Override
    public Iterable<class_2248> blockIterable() {
        return this.blocks.entryIterable();
    }

    @Override
    public Iterable<class_1792> itemIterable() {
        return () -> this.blocks.getEntries().stream().map(block -> {
            class_1792 item = ((class_2248)block.get()).method_8389();
            if (item != null && item != class_1802.field_8162) {
                return Optional.of(item);
            }
            return Optional.empty();
        }).flatMap(Optional::stream).iterator();
    }

    @Override
    public CommonRegister<class_2248> getBlockRegister() {
        return this.blocks;
    }

    @Override
    public CommonRegister<class_1792> getItemRegister() {
        return this.items;
    }

    public static class FabricBlockRegistryEntry<B extends class_2248, I extends class_1792>
    implements BlockRegistryEntry<B, I> {
        private final RegistryEntry<B> block;
        private final RegistryEntry<I> item;

        FabricBlockRegistryEntry(RegistryEntry<B> block, RegistryEntry<I> item) {
            this.block = block;
            this.item = item;
        }

        @Override
        public B get() {
            return (B)((class_2248)this.block.get());
        }

        @Override
        public class_2960 getId() {
            return this.block.getId();
        }

        @Override
        public class_5321<B> getKey() {
            return this.block.getKey();
        }

        @Override
        public Optional<class_6880<B>> getHolder() {
            return this.block.getHolder();
        }

        @Override
        public boolean isPresent() {
            return this.block.isPresent();
        }

        @Override
        public I getItem() {
            return (I)((class_1792)this.item.get());
        }

        @Override
        public class_2960 getItemId() {
            return this.item.getId();
        }

        @Override
        public class_5321<I> getItemKey() {
            return this.item.getKey();
        }

        @Override
        public Optional<class_6880<I>> getItemHolder() {
            return this.item.getHolder();
        }

        @Override
        public boolean isItemPresent() {
            return this.item.isPresent();
        }

        @Override
        public RegistryEntry<I> getItemRegistryEntry() {
            return this.item;
        }
    }

    public static class Factory
    implements BlockRegister.Factory {
        @Override
        public BlockRegister create(String modid) {
            return new FabricBlockRegister(modid);
        }
    }
}

