package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TextSettingsProvider;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4587;

public class UEditBox extends class_342 implements RenderTickable, PerspectiveRenderable, BackgroundColorProvider, TextSettingsProvider {
	
	protected static final RGBA BLACK = RGBA.BLACK;
	protected static final RGBA WHITE = RGBA.WHITE;
	
	protected static final RGBA LIGHT_GRAY = new RGBA(0xE0E0E0FF);
	protected static final RGBA LIGHTER_GRAY = new RGBA(0xD0D0D0FF);
	protected static final RGBA GRAY = new RGBA(0xA0A0A0FF);
	protected static final RGBA DARKER_GRAY = new RGBA(0x808080FF);
	protected static final RGBA DARK_GRAY = new RGBA(0x707070FF);
	
	protected RGBA backgroundFrameColor;
	protected RGBA unfocusedBackgroundFrameColor;
	protected RGBA backgroundColor;
	
	protected RGBA textColor;
	protected RGBA disabledTextColor;
	protected RGBA hintTextColor;
	protected RGBA suggestionTextColor;
	
	protected RGBA cursorColor;
	
	public UEditBox(class_327 font, int x, int y, int width, int height, UEditBox previousEditBox, class_2561 title) {
		super(font, x, y, width, height, title);
		setPreviousText(previousEditBox);
		backgroundFrameColor = WHITE;
		unfocusedBackgroundFrameColor = GRAY;
		backgroundColor = BLACK;
		textColor = LIGHT_GRAY;
		disabledTextColor = DARK_GRAY;
		hintTextColor = LIGHT_GRAY;
		suggestionTextColor = DARKER_GRAY;
		cursorColor = LIGHTER_GRAY;
	}
	
	public RGBA getBackgroundFrameColor() {
		return backgroundFrameColor;
	}
	
	public void setBackgroundFrameColor(RGBA backgroundFrameColor) {
		this.backgroundFrameColor = backgroundFrameColor;
	}
	
	public RGBA getUnfocusedBackgroundFrameColor() {
		return unfocusedBackgroundFrameColor;
	}
	
	public void setUnfocusedBackgroundFrameColor(RGBA unfocusedBackgroundFrameColor) {
		this.unfocusedBackgroundFrameColor = unfocusedBackgroundFrameColor;
	}
	
	public RGBA getBackgroundColor() {
		return backgroundColor;
	}
	
	public void setBackgroundColor(RGBA backgroundColor) {
		this.backgroundColor = backgroundColor;
	}
	
	public RGBA getTextColor() {
		return textColor;
	}
	
	public void setTextColor(RGBA textColor) {
		this.textColor = textColor;
	}
	
	public RGBA getDisabledTextColor() {
		return disabledTextColor;
	}
	
	public void setDisabledTextColor(RGBA disabledTextColor) {
		this.disabledTextColor = disabledTextColor;
	}
	
	public RGBA getHintTextColor() {
		return hintTextColor;
	}
	
	public void setHintTextColor(RGBA hintTextColor) {
		this.hintTextColor = hintTextColor;
	}
	
	public RGBA getSuggestionTextColor() {
		return suggestionTextColor;
	}
	
	public void setSuggestionTextColor(RGBA suggestionTextColor) {
		this.suggestionTextColor = suggestionTextColor;
	}
	
	public RGBA getCursorColor() {
		return cursorColor;
	}
	
	public void setCursorColor(RGBA cursorColor) {
		this.cursorColor = cursorColor;
	}
	
	@Override
	public void method_1868(int color) {
		super.method_1868(color);
		setTextColor(RGBA.fromARGB(color));
	}
	
	@Override
	public void method_1860(int color) {
		super.method_1860(color);
		setDisabledTextColor(RGBA.fromARGB(color));
	}
	
	public void setPreviousText(UEditBox textField) {
		if (textField != null) {
			field_2092 = textField.field_2092;
			field_2108 = textField.field_2108;
			field_2103 = textField.field_2103;
			field_2102 = textField.field_2102;
			field_2101 = textField.field_2101;
		}
	}
	
	@Override
	public void renderTick() {
		method_1865();
	}
	
	@Override
	public void method_48579(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		renderBackground(poseStack, mouseX, mouseY, partialTick);
		renderForeground(poseStack, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderBackground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		if (field_2095) {
			method_25294(poseStack, field_22760 - 1, field_22761 - 1, field_22760 + field_22758 + 1, field_22761 + field_22759 + 1, WidgetUtil.respectWidgetAlpha(this, getCurrentBackgroundFrameColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
			method_25294(poseStack, field_22760, field_22761, field_22760 + field_22758, field_22761 + field_22759, WidgetUtil.respectWidgetAlpha(this, getCurrentBackgroundColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
		}
	}
	
	@Override
	public void renderForeground(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		final RGBA currentTextColor = WidgetUtil.respectWidgetAlpha(this, getCurrentTextColor(poseStack, mouseX, mouseY, partialTick));
		
		final String currentText = field_2105.method_27523(field_2092.substring(field_2103), method_1859());
		
		final int cursorOffset = field_2102 - field_2103;
		final int selectionOffset = Math.min(field_2101 - field_2103, currentText.length());
		
		final boolean isCursorInText = cursorOffset >= 0 && cursorOffset <= currentText.length();
		final boolean shouldCursorBlink = method_25370() && field_2107 / 6 % 2 == 0 && isCursorInText;
		final boolean isCursorInTheMiddle = field_2102 < field_2092.length() || field_2092.length() >= field_2108;
		
		final int xOffset = field_2095 ? field_22760 + 4 : field_22760;
		final int yOffset = field_2095 ? field_22761 + (field_22759 - 8) / 2 : field_22761;
		
		int leftRenderedTextX = xOffset;
		
		if (!currentText.isEmpty()) {
			final String firstTextPart = isCursorInText ? currentText.substring(0, cursorOffset) : currentText;
			leftRenderedTextX = field_2105.method_27517(poseStack, field_2099.apply(firstTextPart, field_2103), xOffset, yOffset, currentTextColor.getColorARGB());
		}
		
		int rightRenderedTextX = leftRenderedTextX;
		
		if (!isCursorInText) {
			rightRenderedTextX = cursorOffset > 0 ? xOffset + field_22758 : xOffset;
		} else if (isCursorInTheMiddle) {
			rightRenderedTextX = leftRenderedTextX - 1;
			--leftRenderedTextX;
		}
		
		if (!currentText.isEmpty() && isCursorInText && cursorOffset < currentText.length()) {
			field_2105.method_27517(poseStack, field_2099.apply(currentText.substring(cursorOffset), field_2102), leftRenderedTextX, yOffset, currentTextColor.getColorARGB());
		}
		
		if (field_41100 != null && currentText.isEmpty() && !method_25370()) {
			field_2105.method_30881(poseStack, field_41100, leftRenderedTextX, yOffset, WidgetUtil.respectWidgetAlpha(this, getCurrentHintTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
		}
		
		if (!isCursorInTheMiddle && field_2106 != null) {
			field_2105.method_1720(poseStack, field_2106, rightRenderedTextX - 1, yOffset, WidgetUtil.respectWidgetAlpha(this, getCurrentSuggestionTextColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
		}
		
		if (shouldCursorBlink) {
			if (isCursorInTheMiddle) {
				class_332.method_25294(poseStack, rightRenderedTextX, yOffset - 1, rightRenderedTextX + 1, yOffset + 1 + 9, WidgetUtil.respectWidgetAlpha(this, getCurrentCursorColor(poseStack, mouseX, mouseY, partialTick)).getColorARGB());
			} else {
				field_2105.method_1720(poseStack, "_", rightRenderedTextX, yOffset, currentTextColor.getColorARGB());
			}
		}
		
		if (selectionOffset != cursorOffset) {
			final int selectedX = xOffset + field_2105.method_1727(currentText.substring(0, selectionOffset));
			method_1886(poseStack, rightRenderedTextX, yOffset - 1, selectedX - 1, yOffset + 1 + 9);
		}
	}
	
	@Override
	public RGBA getCurrentBackgroundColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return backgroundColor;
	}
	
	public RGBA getCurrentBackgroundFrameColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return method_25370() ? backgroundFrameColor : unfocusedBackgroundFrameColor;
	}
	
	@Override
	public RGBA getCurrentTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return field_2094 ? textColor : disabledTextColor;
	}
	
	public RGBA getCurrentHintTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return hintTextColor;
	}
	
	public RGBA getCurrentSuggestionTextColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return suggestionTextColor;
	}
	
	public RGBA getCurrentCursorColor(class_4587 poseStack, int mouseX, int mouseY, float partialTick) {
		return cursorColor;
	}
}
