package info.u_team.u_team_core.gui.elements;

import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public abstract sealed class AbstractSliderLogic extends class_357 permits USlider {
	
	protected static final OnSliderChange EMPTY_SLIDER = slider -> {
	};
	
	protected final class_2561 prefix;
	protected final class_2561 suffix;
	
	protected final double minValue;
	protected final double maxValue;
	
	protected final boolean decimalPrecision;
	protected int precision = 1;
	protected final boolean drawDescription;
	
	protected OnSliderChange slider;
	
	protected AbstractSliderLogic(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean decimalPrecision, boolean drawDescription, OnSliderChange slider) {
		super(x, y, width, height, class_2561.method_43473(), 0);
		this.prefix = prefix;
		this.suffix = suffix;
		this.minValue = minValue;
		this.maxValue = maxValue;
		field_22753 = clampValues((currentValue - minValue) / (maxValue - minValue));
		this.decimalPrecision = decimalPrecision;
		this.drawDescription = drawDescription;
		
		if (drawDescription) {
			final String displayValue;
			
			if (decimalPrecision) {
				displayValue = Double.toString(field_22753 * (maxValue - minValue) + minValue);
				precision = Math.min(displayValue.substring(displayValue.indexOf(".") + 1).length(), 4);
			} else {
				displayValue = Integer.toString((int) Math.round(field_22753 * (maxValue - minValue) + minValue));
				precision = 0;
			}
			
			method_25355(class_2561.method_43473().method_10852(prefix).method_27693(displayValue).method_10852(suffix));
		} else {
			method_25355(class_2561.method_43473());
		}
		
		this.slider = slider;
	}
	
	public void setSlider(OnSliderChange slider) {
		this.slider = slider;
	}
	
	public void setSlider(Runnable runnable) {
		slider = slider -> runnable.run();
	}
	
	@Override
	protected void method_25346() {
		updateSliderText();
	}
	
	@Override
	protected void method_25344() {
		slider.onChange(this);
	}
	
	@Override
	protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
		if (field_22763 && field_22764) {
			super.method_25349(mouseX, mouseY, dragX, dragY);
		}
	}
	
	public void updateSliderText() {
		String displayValue;
		
		if (decimalPrecision) {
			displayValue = Double.toString(field_22753 * (maxValue - minValue) + minValue);
			
			if (displayValue.substring(displayValue.indexOf(".") + 1).length() > precision) {
				displayValue = displayValue.substring(0, displayValue.indexOf(".") + precision + 1);
				
				if (displayValue.endsWith(".")) {
					displayValue = displayValue.substring(0, displayValue.indexOf(".") + precision);
				}
			} else {
				while (displayValue.substring(displayValue.indexOf(".") + 1).length() < precision) {
					displayValue = displayValue + "0";
				}
			}
		} else {
			displayValue = Integer.toString((int) Math.round(field_22753 * (maxValue - minValue) + minValue));
		}
		
		if (drawDescription) {
			method_25355(class_2561.method_43473().method_10852(prefix).method_27693(displayValue).method_10852(suffix));
		}
	}
	
	public int getValueInt() {
		return (int) getValueLong();
	}
	
	public long getValueLong() {
		return Math.round(getValue());
	}
	
	public double getValue() {
		return field_22753 * (maxValue - minValue) + minValue;
	}
	
	public void method_25347(double newValue) {
		field_22753 = clampValues((newValue - minValue) / (maxValue - minValue));
		updateSliderText();
	}
	
	private double clampValues(double value) {
		return class_3532.method_15350(value, 0, 1);
	}
	
	public static interface OnSliderChange {
		
		void onChange(AbstractSliderLogic slider);
	}
}
