package info.u_team.u_team_core.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;

public class ColorUtil {
	
	private static final BiMap<class_2248, class_1767> WOOL_DYE_COLORS = HashBiMap.create();
	
	public static final int WHITE_RGBA = 0xFFFFFFFF;
	public static final int WHITE_RGB = 0xFFFFFF;
	
	static {
		WOOL_DYE_COLORS.put(class_2246.field_10446, class_1767.field_7952);
		WOOL_DYE_COLORS.put(class_2246.field_10095, class_1767.field_7946);
		WOOL_DYE_COLORS.put(class_2246.field_10215, class_1767.field_7958);
		WOOL_DYE_COLORS.put(class_2246.field_10294, class_1767.field_7951);
		WOOL_DYE_COLORS.put(class_2246.field_10490, class_1767.field_7947);
		WOOL_DYE_COLORS.put(class_2246.field_10028, class_1767.field_7961);
		WOOL_DYE_COLORS.put(class_2246.field_10459, class_1767.field_7954);
		WOOL_DYE_COLORS.put(class_2246.field_10423, class_1767.field_7944);
		WOOL_DYE_COLORS.put(class_2246.field_10222, class_1767.field_7967);
		WOOL_DYE_COLORS.put(class_2246.field_10619, class_1767.field_7955);
		WOOL_DYE_COLORS.put(class_2246.field_10259, class_1767.field_7945);
		WOOL_DYE_COLORS.put(class_2246.field_10514, class_1767.field_7966);
		WOOL_DYE_COLORS.put(class_2246.field_10113, class_1767.field_7957);
		WOOL_DYE_COLORS.put(class_2246.field_10170, class_1767.field_7942);
		WOOL_DYE_COLORS.put(class_2246.field_10314, class_1767.field_7964);
		WOOL_DYE_COLORS.put(class_2246.field_10146, class_1767.field_7963);
	}
	
	public static class_2248 getWoolFromColor(class_1767 color) {
		return WOOL_DYE_COLORS.inverse().get(color);
	}
	
	public static class_1767 getColorFromWool(class_1792 item) {
		return getColorFromWool(class_2248.method_9503(item));
	}
	
	public static class_1767 getColorFromWool(class_2248 block) {
		return WOOL_DYE_COLORS.get(block);
	}
	
	public static class_1767 findClosestDyeColor(RGB rgb) {
		class_1767 match = class_1767.field_7952;
		double clostestMatch = Double.MAX_VALUE;
		for (final class_1767 color : class_1767.values()) {
			final RGB textureColor = new RGB(color.method_7787());
			final double difference = Math.pow(textureColor.getRedComponent() - rgb.getRedComponent(), 2) + Math.pow(textureColor.getGreenComponent() - rgb.getGreenComponent(), 2) + Math.pow(textureColor.getBlueComponent() - rgb.getBlueComponent(), 2);
			if (difference < clostestMatch) {
				clostestMatch = difference;
				match = color;
			}
		}
		return match;
	}
}
