package info.u_team.u_team_core.recipeserializer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public abstract class UShapedRecipeSerializer<T extends class_1869> implements class_1865<T> {
	
	private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> {
		return instance.group(Codec.STRING.optionalFieldOf("group", "").forGetter(recipe -> {
			return recipe.field_9056;
		}), class_7710.field_40252.fieldOf("category").orElse(class_7710.field_40251).forGetter(recipe -> {
			return recipe.field_40256;
		}), class_8957.field_47321.forGetter((recipe) -> {
			return recipe.field_47320;
		}), class_1799.field_51397.fieldOf("result").forGetter(recipe -> {
			return recipe.field_9053;
		}), Codec.BOOL.optionalFieldOf("show_notification", Boolean.valueOf(true)).forGetter(recipe -> {
			return recipe.field_42719;
		})).apply(instance, this::createRecipe);
	});
	
	private final class_9139<class_9129, T> stream_codec = class_9139.method_56437(this::toNetwork, this::fromNetwork);
	
	@Override
	public MapCodec<T> method_53736() {
		return codec;
	}
	
	@Override
	public class_9139<class_9129, T> method_56104() {
		return stream_codec;
	}
	
	public T fromNetwork(class_9129 buffer) {
		final String group = buffer.method_19772();
		final class_7710 category = buffer.method_10818(class_7710.class);
		final class_8957 pattern = class_8957.field_48359.decode(buffer);
		final class_1799 result = class_1799.field_48349.decode(buffer);
		final boolean showNotification = buffer.readBoolean();
		return createRecipe(group, category, pattern, result, showNotification);
	}
	
	public void toNetwork(class_9129 buffer, T recipe) {
		buffer.method_10814(recipe.field_9056);
		buffer.method_10817(recipe.field_40256);
		class_8957.field_48359.encode(buffer, recipe.field_47320);
		class_1799.field_48349.encode(buffer, recipe.field_9053);
		buffer.method_52964(recipe.field_42719);
	}
	
	protected abstract T createRecipe(String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification);
	
	protected record ShapedRecipeValues(String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification) {
		
		public ShapedRecipeValues(class_1869 shapedRecipe) {
			this(shapedRecipe.field_9056, shapedRecipe.field_40256, shapedRecipe.field_47320, shapedRecipe.field_9053, shapedRecipe.field_42719);
		}
	}
	
}
