package info.u_team.u_team_core.impl.common;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.api.network.NetworkHandler;
import info.u_team.u_team_core.api.network.NetworkMessage;
import info.u_team.u_team_core.api.network.NetworkPayload;
import info.u_team.u_team_core.util.NetworkUtil;

public abstract class CommonNetworkHandler implements NetworkHandler {
	
	protected static final Logger LOGGER = LoggerFactory.getLogger("NetworkHandler");
	
	protected final class_2960 networkId;
	protected final int protocolVersion;
	
	protected final Map<class_8710.class_9154<?>, MessagePacketPayload<?>> messages;
	
	protected CommonNetworkHandler(class_2960 networkId, int protocolVersion) {
		this.networkId = networkId;
		this.protocolVersion = protocolVersion;
		messages = new HashMap<>();
	}
	
	public <M> NetworkMessage<M> createNetworkMessage(MessagePacketPayload<M> messagePayload) {
		return new CommonNetworkMessage<>(messagePayload);
	}
	
	@Override
	public <M> NetworkMessage<M> register(String id, NetworkPayload<M> payload) {
		final class_2960 messageId = networkId.method_48331("/" + id);
		final MessagePacketPayload<M> messagePayload = new MessagePacketPayload<>(messageId, payload);
		
		if (messages.put(messagePayload.type, messagePayload) != null) {
			throw new IllegalArgumentException("Duplicate message id " + messageId);
		}
		
		return createNetworkMessage(messagePayload);
	}
	
	@Override
	public class_2960 getNetworkId() {
		return networkId;
	}
	
	@Override
	public int getProtocolVersion() {
		return protocolVersion;
	}
	
	protected static class MessagePacketPayload<M> {
		
		private final class_8710.class_9154<class_8710> type;
		private final class_9139<? super class_9129, class_8710> streamCodec;
		private final NetworkPayload<M> payload;
		
		private MessagePacketPayload(class_2960 messageId, NetworkPayload<M> payload) {
			this.payload = payload;
			type = new class_8710.class_9154<>(messageId);
			streamCodec = cast(payload.streamCodec().method_56432(CustomPacketPayloadImpl::new, CustomPacketPayloadImpl::getMessage));
		}
		
		public NetworkPayload<M> payload() {
			return payload;
		}
		
		public class_8710.class_9154<class_8710> type() {
			return type;
		}
		
		public class_9139<? super class_9129, class_8710> streamCodec() {
			return streamCodec;
		}
		
		public void handle(class_8710 customPacketPayload, NetworkContext context) {
			handle(cast(customPacketPayload).getMessage(), context);
		}
		
		private class_8710 createCustomPacketPayload(M message) {
			return new CustomPacketPayloadImpl(message);
		}
		
		private boolean canWrite(NetworkEnvironment handlerEnvironment) {
			if (!payload.handlerEnvironment().isValid(handlerEnvironment)) {
				LOGGER.error("Failed to write message to channel {} because not handler is defined on the {} environment. Expected {} environment", type.comp_2242(), handlerEnvironment, payload.handlerEnvironment());
				return false;
			}
			return true;
		}
		
		private void handle(M message, NetworkContext context) {
			if (message == null) {
				return;
			}
			final NetworkEnvironment current = context.getEnvironment();
			if (!payload.handlerEnvironment().isValid(current)) {
				LOGGER.error("Message {} in channel {} cannot be handled on the {} environment. Expected {} environment", message.getClass(), type.comp_2242(), current, payload.handlerEnvironment());
				return;
			}
			try {
				payload.handle(message, context);
			} catch (final Exception ex) {
				LOGGER.error("Failed to handle message {} in channel {}", message.getClass(), type.comp_2242(), ex);
			}
		}
		
		private class CustomPacketPayloadImpl implements class_8710 {
			
			private final M message;
			
			private CustomPacketPayloadImpl(M message) {
				this.message = message;
			}
			
			@Override
			public class_8710.class_9154<? extends class_8710> method_56479() {
				return type;
			}
			
			private M getMessage() {
				return message;
			}
		}
		
		@SuppressWarnings("unchecked")
		private class_9139<? super class_9129, class_8710> cast(class_9139<? super class_9129, ? extends class_8710> streamCodec) {
			return (class_9139<? super class_9129, class_8710>) streamCodec;
		}
		
		@SuppressWarnings("unchecked")
		private CustomPacketPayloadImpl cast(class_8710 customPacketPayload) {
			return (CustomPacketPayloadImpl) customPacketPayload;
		}
	}
	
	protected static class CommonNetworkMessage<M> implements NetworkMessage<M> {
		
		protected final MessagePacketPayload<M> messagePayload;
		
		protected CommonNetworkMessage(MessagePacketPayload<M> messagePayload) {
			this.messagePayload = messagePayload;
		}
		
		@Override
		public class_8710 packet(M message) {
			return messagePayload.createCustomPacketPayload(message);
		}
		
		@Override
		public class_2596<?> packet(NetworkEnvironment toEnvironment, M message) {
			final class_8710 payload = packet(message);
			return switch (toEnvironment) {
			case CLIENT -> NetworkUtil.createClientBoundPacket(payload);
			case SERVER -> NetworkUtil.createServerBoundPacket(payload);
			};
		}
		
		@Override
		public void sendToPlayer(class_3222 player, M message) {
			if (messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
				NetworkUtil.sendToPlayer(player, packet(NetworkEnvironment.CLIENT, message));
			}
		}
		
		@Override
		public void sendToConnection(class_2535 connection, M message) {
			if (messagePayload.canWrite(NetworkEnvironment.CLIENT)) {
				NetworkUtil.sendToConnection(connection, packet(NetworkEnvironment.CLIENT, message));
			}
		}
		
		@Override
		public void sendToServer(M message) {
			if (messagePayload.canWrite(NetworkEnvironment.SERVER)) {
				NetworkUtil.sendToServer(packet(NetworkEnvironment.SERVER, message));
			}
		}
		
	}
	
	protected static abstract class CommonNetworkContext<M> implements NetworkContext {
		
		protected final MessagePacketPayload<M> messagePayload;
		
		protected CommonNetworkContext(MessagePacketPayload<M> messagePayload) {
			this.messagePayload = messagePayload;
		}
		
		protected abstract CompletableFuture<Void> execute(Runnable runnable);
		
		@Override
		public final CompletableFuture<Void> executeOnMainThread(Runnable runnable) {
			return execute(() -> {
				try {
					runnable.run();
				} catch (final Exception ex) {
					LOGGER.error("Failed to handle synchronized message in channel {}", messagePayload.type().comp_2242(), ex);
				}
			});
		}
		
	}
}
