package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface EntityTypeRegister extends Iterable<RegistryEntry<class_1299<?>>> {
	
	static EntityTypeRegister create(String modid) {
		return new EntityTypeRegister() {
			
			private final CommonRegister<class_1299<?>> register = CommonRegister.create(class_7924.field_41266, modid);
			
			private static final String DUMMY_ENTRY = "egg"; // Pass a vanilla minecraft entity here, so we don't get the complain about a missing data fixer
			
			@Override
			public <T extends class_1297> RegistryEntry<class_1299<T>> register(String name, Function<class_2960, class_1299.class_1300<T>> function) {
				return register.register(name, location -> function.apply(location).method_5905(DUMMY_ENTRY));
			}
			
			@Override
			public <T extends class_1297> RegistryEntry<class_1299<T>> register(String name, Supplier<class_1299.class_1300<T>> supplier) {
				return register.register(name, () -> supplier.get().method_5905(DUMMY_ENTRY));
			}
			
			@Override
			public void register() {
				register.register();
			}
			
			@Override
			public String getModid() {
				return register.getModid();
			}
			
			@Override
			public class_5321<? extends class_2378<class_1299<?>>> getRegistryKey() {
				return register.getRegistryKey();
			}
			
			@Override
			public Collection<RegistryEntry<class_1299<?>>> getEntries() {
				return register.getEntries();
			}
			
			@Override
			public Iterator<RegistryEntry<class_1299<?>>> iterator() {
				return register.iterator();
			}
			
			@Override
			public Iterable<class_1299<?>> entryIterable() {
				return register.entryIterable();
			}
			
			@Override
			public CommonRegister<class_1299<?>> getCommonRegister() {
				return register;
			}
		};
	}
	
	<T extends class_1297> RegistryEntry<class_1299<T>> register(String name, Function<class_2960, class_1299.class_1300<T>> function);
	
	<T extends class_1297> RegistryEntry<class_1299<T>> register(String name, Supplier<class_1299.class_1300<T>> supplier);
	
	void register();
	
	String getModid();
	
	class_5321<? extends class_2378<class_1299<?>>> getRegistryKey();
	
	Collection<RegistryEntry<class_1299<?>>> getEntries();
	
	Iterable<class_1299<?>> entryIterable();
	
	CommonRegister<class_1299<?>> getCommonRegister();
}
