package info.u_team.u_team_core.api.block;

import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1270;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.MenuUtil;
import io.netty.buffer.Unpooled;

/**
 * Provides a convenience way to implement block entities for blocks.
 *
 * @author HyCraftHD
 */
public interface EntityBlockProvider extends class_2343 {
	
	/**
	 * Returns the {@link class_2591} that is used for creating the {@link class_2586} when
	 * {@link #method_10123(class_2338, class_2680)} is invoked. Can return null if for the current state or position no
	 * block entity should be created.
	 *
	 * @param pos Position of the block
	 * @param state Block state
	 */
	class_2591<?> blockEntityType(class_2338 pos, class_2680 state);
	
	/**
	 * Returns a new {@link class_2586} for the give {@link class_2338} and {@link class_2680}. <br>
	 * The default implementation creates a new {@link class_2586} by using the
	 * {@link #blockEntityType(class_2338, class_2680)} method and invoke {@link class_2591#method_11032(class_2338, class_2680)}
	 * Can return null if no block entity should be created for that position or state.
	 *
	 * @param pos Position of the block
	 * @param state Block state
	 */
	@Override
	default class_2586 method_10123(class_2338 pos, class_2680 state) {
		final class_2591<?> type = blockEntityType(pos, state);
		if (type != null) {
			return type.method_11032(pos, state);
		}
		return null;
	}
	
	/**
	 * Returns a optional with can contain the {@link class_2586} at that give position if the {@link class_2591} is
	 * correct. Otherwise returns an empty optional.
	 *
	 * @param <T> Block entity
	 * @param level Level
	 * @param pos Position of the block
	 * @return Optional with the block entity
	 */
	default <T extends class_2586> Optional<T> getBlockEntity(class_1922 level, class_2338 pos) {
		return getMatchingBlockEntity(level, pos);
	}
	
	/**
	 * Opens the menu that is specified in the block entity with {@link class_1270}. If the block entity implements
	 * {@link MenuSyncedBlockEntity} then the {@link MenuSyncedBlockEntity#sendInitialMenuDataToClient(class_2540)} is
	 * called and the data will be send to the client. The container cannot be opened when secondary use is active.
	 *
	 * @param level Level
	 * @param pos The block entities position
	 * @param player The player that opens the block entity
	 * @return {@link class_1269} if the container could be opened
	 */
	default class_1269 openMenu(class_1937 level, class_2338 pos, class_1657 player) {
		return openMenu(level, pos, player, false);
	}
	
	/**
	 * Opens the menu that is specified in the block entity with {@link class_1270}. If the block entity implements
	 * {@link MenuSyncedBlockEntity} then the {@link MenuSyncedBlockEntity#sendInitialMenuDataToClient(class_2540)} is
	 * called and the data will be send to the client.
	 *
	 * @param level Level
	 * @param pos The block entities position
	 * @param player The player that opens the block entity
	 * @param canOpenWhenSecondaryUse If the container can be opened when secondary use is active
	 * @return {@link class_1269} if the container could be opened
	 */
	default class_1269 openMenu(class_1937 level, class_2338 pos, class_1657 player, boolean canOpenWhenSecondaryUse) {
		if (level.method_8608() || !(player instanceof final class_3222 serverPlayer)) {
			return class_1269.field_5812;
		}
		
		final Optional<class_2586> blockEntityOptional = getBlockEntity(level, pos);
		
		if (!blockEntityOptional.isPresent()) {
			return class_1269.field_5811;
		}
		
		final class_2586 blockEntity = blockEntityOptional.get();
		
		if (!(blockEntity instanceof final class_3908 menuProvider)) {
			return class_1269.field_5811;
		}
		
		if (!canOpenWhenSecondaryUse && serverPlayer.method_21823()) {
			return class_1269.field_5812;
		}
		
		final class_2540 data = new class_2540(Unpooled.buffer());
		if (blockEntity instanceof final MenuSyncedBlockEntity syncedBlockEntity) {
			syncedBlockEntity.sendInitialMenuDataToClient(data);
		}
		
		MenuUtil.openMenu(serverPlayer, menuProvider, byteBuf -> {
			byteBuf.method_10807(pos);
			byteBuf.method_10804(data.readableBytes());
			byteBuf.method_52975(data);
			data.release();
		}, false);
		
		return class_1269.field_5812;
	}
	
	/**
	 * Private helper method to avoid exposing the unchecked cast. Tries to find the matching block entity for our type in
	 * the world at the give position.
	 *
	 * @param <T> Block entity
	 * @param level Level
	 * @param pos Position of the block
	 * @return Optional with the block entity
	 */
	private <T extends class_2586> Optional<T> getMatchingBlockEntity(class_1922 level, class_2338 pos) {
		return CastUtil.uncheckedCast(level.method_35230(pos, blockEntityType(pos, level.method_8320(pos))));
	}
	
}
