/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.screen;

import info.u_team.u_team_core.api.gui.PerspectiveRenderable;
import info.u_team.u_team_core.api.gui.RenderTickable;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.menu.UContainerMenu;
import info.u_team.u_team_core.screen.FluidContainerMenuScreen;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;

public class UContainerMenuScreen<T extends class_1703>
extends FluidContainerMenuScreen<T>
implements PerspectiveRenderable,
TooltipRenderable {
    protected static final RGBA DEFAULT_TEXT_COLOR = new RGBA(0x404040FF);
    protected class_2960 background;
    protected int backgroundWidth;
    protected int backgroundHeight;
    protected RGBA backgroundColor;
    protected boolean drawTitleText;
    protected boolean drawInventoryText;
    protected RGBA textColor;

    public UContainerMenuScreen(T menu, class_1661 playerInventory, class_2561 title, class_2960 background, int imageWidth, int imageHeight) {
        this(menu, playerInventory, title, background);
        this.setImageDimensions(imageWidth, imageHeight);
    }

    public UContainerMenuScreen(T menu, class_1661 playerInventory, class_2561 title, class_2960 background) {
        super(menu, playerInventory, title);
        this.background = background;
        this.backgroundWidth = 256;
        this.backgroundHeight = 256;
        this.backgroundColor = RGBA.WHITE;
        this.drawTitleText = true;
        this.drawInventoryText = true;
        this.textColor = DEFAULT_TEXT_COLOR;
    }

    protected void setBackground(class_2960 background) {
        this.background = background;
    }

    protected void setBackgroundDimensions(int size) {
        this.setBackgroundDimensions(size, size);
    }

    protected void setBackgroundDimensions(int backgroundWidth, int backgroundHeight) {
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
    }

    protected void setImageDimensions(int imageWidth, int imageHeight) {
        this.field_2792 = imageWidth;
        this.field_2779 = imageHeight;
        this.setDefaultTextLocation();
    }

    protected void setDrawText(boolean drawTitleText, boolean drawInventoryText) {
        this.drawTitleText = drawTitleText;
        this.drawInventoryText = drawInventoryText;
    }

    protected void setDefaultTextLocation() {
        this.setTextLocation(8, 6, 8, this.field_2779 - 94);
    }

    protected void setTextLocation(int titleLabelX, int titleLabelY, int inventoryLabelX, int inventoryLabelY) {
        this.field_25267 = titleLabelX;
        this.field_25268 = titleLabelY;
        this.field_25269 = inventoryLabelX;
        this.field_25270 = inventoryLabelY;
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    public void renderBehind(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2388(guiGraphics, mouseX, mouseY);
        if (this.drawTitleText) {
            guiGraphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, this.textColor.getColorARGB(), false);
        }
        if (this.drawInventoryText) {
            guiGraphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, this.textColor.getColorARGB(), false);
        }
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderUtil.drawTexturedQuad(guiGraphics.method_51448(), this.field_2776, this.field_2800, this.field_2792, this.field_2779, this.field_2792, this.field_2779, 0.0f, 0.0f, this.backgroundWidth, this.backgroundHeight, 0.0f, this.background, this.backgroundColor);
    }

    public void method_37432() {
        for (class_364 listener : this.method_25396()) {
            if (!(listener instanceof RenderTickable)) continue;
            RenderTickable tickable = (RenderTickable)listener;
            tickable.renderTick();
        }
        class_1703 class_17032 = this.field_2797;
        if (class_17032 instanceof UContainerMenu) {
            UContainerMenu uMenu = (UContainerMenu)class_17032;
            uMenu.broadcastChangesToServer();
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        class_364 focused = this.method_25399();
        if (focused != null && this.method_25397() && button == 0) {
            focused.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }
}

