package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.Scalable;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import info.u_team.u_team_core.util.RGBA;
import info.u_team.u_team_core.util.RenderUtil;
import info.u_team.u_team_core.util.WidgetUtil;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public non-sealed class USlider extends AbstractSliderLogic implements WidgetRenderable, BackgroundColorProvider, TextProvider, Scalable, ScaleProvider {
	
	protected static final OnSliderChange EMPTY_SLIDER = AbstractSliderLogic.EMPTY_SLIDER;
	
	protected static final RGBA WHITE = UButton.WHITE;
	protected static final RGBA LIGHT_GRAY = UButton.LIGHT_GRAY;
	
	protected TextureProvider sliderBackgroundTextureProvider;
	protected RGBA sliderBackgroundColor;
	
	protected TextureProvider sliderTextureProvider;
	protected RGBA sliderColor;
	
	protected RGBA textColor;
	protected RGBA disabledTextColor;
	
	protected float scale = 1;
	
	public USlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription) {
		this(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, EMPTY_SLIDER);
	}
	
	public USlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double value, boolean decimalPrecision, boolean drawDescription, OnSliderChange slider) {
		super(x, y, width, height, prefix, suffix, minValue, maxValue, value, decimalPrecision, drawDescription, slider);
		sliderBackgroundTextureProvider = this::method_52716;
		sliderBackgroundColor = WHITE;
		sliderTextureProvider = this::method_52717;
		sliderColor = WHITE;
		textColor = WHITE;
		disabledTextColor = LIGHT_GRAY;
	}
	
	public RGBA getSliderBackgroundColor() {
		return sliderBackgroundColor;
	}
	
	public void setSliderBackgroundColor(RGBA sliderBackgroundColor) {
		this.sliderBackgroundColor = sliderBackgroundColor;
	}
	
	public RGBA getSliderColor() {
		return sliderColor;
	}
	
	public void setSliderColor(RGBA sliderColor) {
		this.sliderColor = sliderColor;
	}
	
	public RGBA getTextColor() {
		return textColor;
	}
	
	public void setTextColor(RGBA textColor) {
		this.textColor = textColor;
	}
	
	public RGBA getDisabledTextColor() {
		return disabledTextColor;
	}
	
	public void setDisabledTextColor(RGBA disabledTextColor) {
		this.disabledTextColor = disabledTextColor;
	}
	
	@Override
	public float getScale() {
		return scale;
	}
	
	@Override
	public void setScale(float scale) {
		this.scale = scale;
	}
	
	@Override
	public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderWidget(this, guiGraphics, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderWidgetTexture(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderButtonLikeTexture(this, sliderBackgroundTextureProvider, guiGraphics, mouseX, mouseY, partialTick);
	}
	
	@Override
	public void renderBehind(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		RenderUtil.setShaderColor(WidgetUtil.respectWidgetAlpha(this, getCurrentSliderColor(guiGraphics, mouseX, mouseY, partialTick)));
		guiGraphics.method_52706(sliderTextureProvider.getTexture(), field_22760 + (int) (field_22753 * (field_22758 - 8)), field_22761, 8, field_22759);
		RenderUtil.resetShaderColor();
	}
	
	@Override
	public void renderBefore(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		WidgetUtil.renderText(this, guiGraphics, mouseX, mouseY, partialTick);
	}
	
	@Override
	public RGBA getCurrentBackgroundColor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return sliderBackgroundColor;
	}
	
	public RGBA getCurrentSliderColor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return sliderColor;
	}
	
	@Override
	public class_2561 getCurrentText() {
		return method_25369();
	}
	
	@Override
	public RGBA getCurrentTextColor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return field_22763 ? textColor : disabledTextColor;
	}
	
	@Override
	public float getCurrentScale(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return scale;
	}
}
