package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9331;

public interface DataComponentTypeRegister extends Iterable<RegistryEntry<class_9331<?>>> {
	
	static DataComponentTypeRegister create(String modid) {
		return new DataComponentTypeRegister() {
			
			private final CommonRegister<class_9331<?>> register = CommonRegister.create(class_7924.field_49659, modid);
			
			@Override
			public <T> RegistryEntry<class_9331<T>> register(String name, Function<class_2960, class_9331.class_9332<T>> function) {
				return register.register(name, location -> function.apply(location).method_57880());
			}
			
			@Override
			public <T> RegistryEntry<class_9331<T>> register(String name, Supplier<class_9331.class_9332<T>> supplier) {
				return register.register(name, () -> supplier.get().method_57880());
			}
			
			@Override
			public void register() {
				register.register();
			}
			
			@Override
			public String getModid() {
				return register.getModid();
			}
			
			@Override
			public class_5321<? extends class_2378<class_9331<?>>> getRegistryKey() {
				return register.getRegistryKey();
			}
			
			@Override
			public Collection<RegistryEntry<class_9331<?>>> getEntries() {
				return register.getEntries();
			}
			
			@Override
			public Iterator<RegistryEntry<class_9331<?>>> iterator() {
				return register.iterator();
			}
			
			@Override
			public Iterable<class_9331<?>> entryIterable() {
				return register.entryIterable();
			}
			
			@Override
			public CommonRegister<class_9331<?>> getCommonRegister() {
				return register;
			}
		};
	}
	
	<T> RegistryEntry<class_9331<T>> register(String name, Function<class_2960, class_9331.class_9332<T>> function);
	
	<T> RegistryEntry<class_9331<T>> register(String name, Supplier<class_9331.class_9332<T>> supplier);
	
	void register();
	
	String getModid();
	
	class_5321<? extends class_2378<class_9331<?>>> getRegistryKey();
	
	Collection<RegistryEntry<class_9331<?>>> getEntries();
	
	Iterable<class_9331<?>> entryIterable();
	
	CommonRegister<class_9331<?>> getCommonRegister();
}
