package info.u_team.u_team_core.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8042;
import net.minecraft.class_8710;

public class NetworkUtil {
	
	public static class_2658 createClientBoundPacket(class_8710 payload) {
		return new class_2658(payload);
	}
	
	public static class_2596<?> createClientBoundBundlePacket(class_8710 mainPayload, class_8710... payloads) {
		if (payloads.length == 0) {
			return createClientBoundPacket(mainPayload);
		} else {
			final List<class_2596<? super class_2602>> packets = new ArrayList<>();
			packets.add(createClientBoundPacket(mainPayload));
			for (final class_8710 payload : payloads) {
				packets.add(createClientBoundPacket(payload));
			}
			return new class_8042(packets);
		}
	}
	
	public static class_2817 createServerBoundPacket(class_8710 payload) {
		return new class_2817(payload);
	}
	
	public static void sendToPlayer(class_3222 player, class_8710 mainPayload, class_8710... payloads) {
		sendToPlayer(player, createClientBoundBundlePacket(mainPayload, payloads));
	}
	
	public static void sendToPlayer(class_3222 player, class_2596<?> packet) {
		player.field_13987.method_14364(packet);
	}
	
	public static void sendToConnection(class_2535 connection, class_8710 mainPayload, class_8710... payloads) {
		sendToConnection(connection, createClientBoundBundlePacket(mainPayload, payloads));
	}
	
	public static void sendToConnection(class_2535 connection, class_2596<?> packet) {
		connection.method_10743(packet);
	}
	
	public static void sendToServer(class_8710 mainPayload, class_8710... payloads) {
		sendToServer(createServerBoundPacket(mainPayload));
		for (final class_8710 payload : payloads) {
			sendToServer(createServerBoundPacket(payload));
		}
	}
	
	public static void sendToServer(class_2596<?> packet) {
		class_310.method_1551().method_1562().method_52787(packet);
	}
	
}
