package info.u_team.u_team_core.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1088;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2960;
import net.minecraft.class_9824;
import com.google.common.collect.ImmutableList;

/**
 * Utility methods for interaction with {@link class_1088} private methods.
 *
 * @author HyCraftHD
 */
public class ModelUtil {
	
	static {
		synchronized (class_9824.field_52266) {
			if (!(class_9824.field_52266 instanceof HashMap)) {
				final Map<class_2960, class_2689<class_2248, class_2680>> mutableMap = new HashMap<>();
				class_9824.field_52266.forEach(mutableMap::put);
				class_9824.field_52266 = mutableMap;
			}
		}
	}
	
	/**
	 * Replace the default state definition with a custom one. Can remove or add states for the model
	 *
	 * @param location Resource location of the model
	 * @param definition Custom state definition
	 */
	public static void addCustomStateContainer(class_2960 location, class_2689<class_2248, class_2680> definition) {
		class_9824.field_52266.put(location, definition);
	}
	
	/**
	 * Utility class for an empty state definition
	 *
	 * @author HyCraftHD
	 */
	public static class EmptyStateDefinition extends class_2689<class_2248, class_2680> {
		
		public EmptyStateDefinition(class_2248 block) {
			super(class_2248::method_9564, block, class_2680::new, new HashMap<>());
		}
		
		@Override
		public ImmutableList<class_2680> method_11662() {
			return method_11660().method_9595().method_11662();
		}
	}
}
