package info.u_team.u_team_core.intern.command.uteamcore;

import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import info.u_team.u_team_core.util.RegistryUtil;

public class ItemStackInfoSubCommand {
	
	private static final String SUCCESS_TRANSLATION_STRING = "commands.uteamcore.stackinfo.success.";
	
	public static ArgumentBuilder<class_2168, ?> register() {
		return class_2170.method_9247("stackinfo").executes(context -> execute(context.getSource()));
	}
	
	private static int execute(class_2168 source) throws CommandSyntaxException {
		final class_1799 stack = source.method_9207().method_6047();
		final class_1792 item = stack.method_7909();
		
		source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "item", createRegistryInfo(item, class_7924.field_41197)), false);
		
		if (item instanceof final class_1747 blockItem) {
			source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "block", createRegistryInfo(blockItem.method_7711(), class_7924.field_41254)), false);
		}
		
		source.method_9226(() -> class_2561.method_43469(SUCCESS_TRANSLATION_STRING + "tag", stack.method_40133().map(tag -> tag.comp_327()).map(class_2960::toString).collect(Collectors.joining(", "))), false);
		
		// TODO evaluate how and what to show with components
		// if (stack.hasTag()) {
		// final MutableComponent component = NbtUtils.toPrettyComponent(stack.getTag()).copy();
		// final Style style = component.getStyle() //
		// .withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, Component.translatable(SUCCESS_TRANSLATION_STRING +
		// "copy").withStyle(ChatFormatting.GREEN))) //
		// .withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, component.getString()));
		// component.setStyle(style);
		// source.sendSuccess(() -> Component.translatable(SUCCESS_TRANSLATION_STRING + "nbt", component), false);
		// }
		return 0;
	}
	
	private static <T> class_2561 createRegistryInfo(T entry, class_5321<class_2378<T>> key) {
		final class_2378<T> vanillaRegistry = RegistryUtil.getBuiltInRegistry(key);
		final class_5250 component = class_2561.method_43470(vanillaRegistry.method_10221(entry).toString());
		final String className = getClassString(entry);
		component.method_27694(style -> style.method_10977(class_124.field_1075) //
				.method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43470(className).method_27692(class_124.field_1054))) //
				.method_10958(new class_2558(class_2558.class_2559.field_11745, className)));
		return component;
	}
	
	private static String getClassString(Object object) {
		return object.getClass().getName() + "@" + Integer.toHexString(object.hashCode());
	}
}
