package info.u_team.u_team_core.api.registry;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public interface BlockEntityTypeRegister extends Iterable<RegistryEntry<class_2591<?>>> {
	
	static BlockEntityTypeRegister create(String modid) {
		return new BlockEntityTypeRegister() {
			
			private final CommonRegister<class_2591<?>> register = CommonRegister.create(class_7924.field_41255, modid);
			
			@Override
			public <T extends class_2586> RegistryEntry<class_2591<T>> register(String name, Function<class_2960, class_2591.class_2592<T>> function) {
				return register.register(name, location -> function.apply(location).method_11034(null));
			}
			
			@Override
			public <T extends class_2586> RegistryEntry<class_2591<T>> register(String name, Supplier<class_2591.class_2592<T>> supplier) {
				return register.register(name, () -> supplier.get().method_11034(null));
			}
			
			@Override
			public void register() {
				register.register();
			}
			
			@Override
			public String getModid() {
				return register.getModid();
			}
			
			@Override
			public class_5321<? extends class_2378<class_2591<?>>> getRegistryKey() {
				return register.getRegistryKey();
			}
			
			@Override
			public Collection<RegistryEntry<class_2591<?>>> getEntries() {
				return register.getEntries();
			}
			
			@Override
			public Iterator<RegistryEntry<class_2591<?>>> iterator() {
				return register.iterator();
			}
			
			@Override
			public Iterable<class_2591<?>> entryIterable() {
				return register.entryIterable();
			}
			
			@Override
			public CommonRegister<class_2591<?>> getCommonRegister() {
				return register;
			}
		};
	}
	
	<T extends class_2586> RegistryEntry<class_2591<T>> register(String name, Function<class_2960, class_2591.class_2592<T>> function);
	
	<T extends class_2586> RegistryEntry<class_2591<T>> register(String name, Supplier<class_2591.class_2592<T>> supplier);
	
	void register();
	
	String getModid();
	
	class_5321<? extends class_2378<class_2591<?>>> getRegistryKey();
	
	Collection<RegistryEntry<class_2591<?>>> getEntries();
	
	Iterable<class_2591<?>> entryIterable();
	
	CommonRegister<class_2591<?>> getCommonRegister();
}
