/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.impl.common;

import info.u_team.u_team_core.api.registry.GameRuleRegister;
import info.u_team.u_team_core.api.registry.LazyEntry;
import info.u_team.u_team_core.util.CastUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1928;

public abstract class CommonGameRuleRegister
implements GameRuleRegister {
    protected final Map<GameRuleLazyEntry<?>, GameRuleData<?>> entries = new LinkedHashMap();

    protected CommonGameRuleRegister() {
    }

    @Override
    public <T extends class_1928.class_4315<T>> LazyEntry<class_1928.class_4313<T>> register(String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type) {
        GameRuleLazyEntry entry = new GameRuleLazyEntry();
        this.entries.put(entry, new GameRuleData(name, category, type));
        return entry;
    }

    @Override
    public Collection<LazyEntry<class_1928.class_4313<?>>> getEntries() {
        return (Collection)CastUtil.uncheckedCast(this.entries.keySet());
    }

    protected void registerEntries() {
        for (Map.Entry<GameRuleLazyEntry<?>, GameRuleData<?>> entry : this.entries.entrySet()) {
            GameRuleLazyEntry<?> registryEntry = entry.getKey();
            GameRuleData<?> data = entry.getValue();
            class_1928.class_4313 key = class_1928.method_8359((String)data.name, (class_1928.class_5198)data.category, data.type.get());
            registryEntry.updateReference(key);
        }
    }

    public static class GameRuleLazyEntry<T extends class_1928.class_4315<T>>
    implements LazyEntry<class_1928.class_4313<T>> {
        private class_1928.class_4313<T> value;

        GameRuleLazyEntry() {
        }

        void updateReference(class_1928.class_4313<?> ruleKey) {
            this.value = (class_1928.class_4313)CastUtil.uncheckedCast(ruleKey);
        }

        @Override
        public class_1928.class_4313<T> get() {
            Objects.requireNonNull(this.value, () -> "Gamerule not present");
            return this.value;
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }
    }

    protected record GameRuleData<T extends class_1928.class_4315<T>>(String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type) {
    }
}

