package info.u_team.u_team_core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import info.u_team.u_team_core.api.gui.BackgroundColorProvider;
import info.u_team.u_team_core.api.gui.ScaleProvider;
import info.u_team.u_team_core.api.gui.TextProvider;
import info.u_team.u_team_core.api.gui.TextSettingsProvider.TextRenderType;
import info.u_team.u_team_core.api.gui.TextureProvider;
import info.u_team.u_team_core.api.gui.TooltipRenderable;
import info.u_team.u_team_core.api.gui.WidgetRenderable;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5244;

public class WidgetUtil {
	
	private static final String ELLIPSIS = "...";
	
	public static <T extends class_339 & WidgetRenderable & BackgroundColorProvider> void renderWidget(T widget, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		RenderSystem.enableDepthTest();
		
		widget.renderWidgetTexture(guiGraphics, mouseX, mouseY, partialTick);
		widget.renderBehind(guiGraphics, mouseX, mouseY, partialTick);
		widget.renderBefore(guiGraphics, mouseX, mouseY, partialTick);
		if (widget instanceof final TooltipRenderable tooltipRenderable) {
			renderCustomTooltipForWidget(tooltipRenderable, guiGraphics, mouseX, mouseY, partialTick);
		}
	}
	
	public static <T extends class_339 & BackgroundColorProvider> void renderButtonLikeTexture(T widget, TextureProvider textureProvider, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		RenderUtil.setShaderColor(respectWidgetAlpha(widget, widget.getCurrentBackgroundColor(guiGraphics, mouseY, mouseY, partialTick)));
		guiGraphics.method_52706(textureProvider.getTexture(), widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364());
		RenderUtil.resetShaderColor();
	}
	
	public static <T extends class_339 & TextProvider> void renderText(T widget, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final class_327 font = widget.getCurrentTextFont();
		final TextRenderType renderType = widget.getCurrentTextRenderType();
		final class_2561 message = widget.getCurrentText();
		final RGBA color = respectWidgetAlpha(widget, widget.getCurrentTextColor(guiGraphics, mouseX, mouseY, partialTick));
		final float scale;
		if (widget instanceof final ScaleProvider scaleProvider) {
			scale = scaleProvider.getCurrentScale(guiGraphics, mouseY, mouseY, partialTick);
		} else {
			scale = 1;
		}
		
		if (message == class_5244.field_39003) {
			return;
		}
		
		final class_4587 poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		poseStack.method_22905(scale, scale, 0);
		
		if (renderType == TextRenderType.ELLIPSIS) {
			renderTextWithCutoff(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
		} else if (renderType == TextRenderType.SCROLLING) {
			renderTextWithScrolling(widget, font, message, color, scale, guiGraphics, mouseX, mouseY, partialTick);
		}
		
		poseStack.method_22909();
	}
	
	private static void renderTextWithScrolling(class_339 widget, class_327 font, class_2561 message, RGBA color, float scale, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final float positionFactor = 1 / scale;
		
		final int maxWidth = widget.method_25368() - 6;
		final int messageWidth = class_3532.method_15386(scale * font.method_27525(message));
		
		final float yStart = (widget.method_46427() + (class_3532.method_15386(widget.method_25364() - 9 * scale)) / 2 + 1) * positionFactor;
		
		if (messageWidth > maxWidth) {
			final int difference = messageWidth - maxWidth;
			
			// Copied from vanilla
			final double d0 = class_156.method_658() / 1000D;
			final double d1 = Math.max(difference * 0.5D, 3.0D);
			final double d2 = Math.sin((Math.PI / 2D) * Math.cos((Math.PI * 2D) * d0 / d1)) / 2.0D + 0.5D;
			final double d3 = class_3532.method_16436(d2, 0.0D, difference);
			
			final float xStart = (widget.method_46426() + 3 - (int) d3) * positionFactor;
			
			guiGraphics.method_44379(widget.method_46426() + 3, widget.method_46427(), widget.method_46426() + widget.method_25368() - 3, widget.method_46427() + widget.method_25364());
			FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
			guiGraphics.method_44380();
		} else {
			final float xStart = (widget.method_46426() + (widget.method_25368() / 2) - messageWidth / 2) * positionFactor;
			FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
		}
	}
	
	private static void renderTextWithCutoff(class_339 widget, class_327 font, class_2561 message, RGBA color, float scale, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final float positionFactor = 1 / scale;
		
		final int maxWidth = widget.method_25368() - 6;
		int messageWidth = class_3532.method_15386(scale * font.method_27525(message));
		final int ellipsisWidth = class_3532.method_15386(scale * font.method_1727(ELLIPSIS));
		
		if (messageWidth > maxWidth && messageWidth > ellipsisWidth) {
			message = class_2561.method_43470(font.method_1714(message, class_3532.method_15375(maxWidth * positionFactor) - ellipsisWidth).getString() + ELLIPSIS);
			messageWidth = maxWidth;
		}
		
		final float xStart = (widget.method_46426() + (widget.method_25368() / 2) - messageWidth / 2) * positionFactor;
		final float yStart = (widget.method_46427() + (class_3532.method_15386(widget.method_25364() - 9 * scale)) / 2 + 1) * positionFactor;
		
		FontUtil.drawString(guiGraphics, font, message, xStart, yStart, color.getColorARGB(), true);
	}
	
	public static RGBA respectWidgetAlpha(class_339 widget, RGBA color) {
		return color.setAlphaComponent(color.getAlphaComponent() * class_3532.method_15363(widget.field_22765, 0, 1));
	}
	
	public static void renderCustomTooltipForWidget(TooltipRenderable renderable, class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		final class_4587 poseStack = guiGraphics.method_51448();
		poseStack.method_22903();
		poseStack.method_46416(0, 0, 400);
		renderable.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
		poseStack.method_22909();
	}
}
