package info.u_team.u_team_core.screen;

import info.u_team.u_team_core.util.ServiceUtil;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_465;

public abstract class FluidContainerMenuScreen<T extends class_1703> extends class_465<T> {
	
	private final FluidContainerScreenDelegator delegator = FluidContainerScreenDelegator.Factory.INSTANCE.create(this);
	
	protected FluidContainerMenuScreen(T container, class_1661 playerInventory, class_2561 title) {
		super(container, playerInventory, title);
	}
	
	@Override
	protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
		delegator.renderLabels(guiGraphics, mouseX, mouseY);
	}
	
	@Override
	protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
		super.method_2380(guiGraphics, mouseX, mouseY);
		delegator.renderTooltip(guiGraphics, mouseX, mouseY);
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (delegator.mouseClicked(mouseX, mouseY, button)) {
			return true;
		} else {
			return super.method_25402(mouseX, mouseY, button);
		}
	}
	
	public FluidContainerScreenDelegator getDelegator() {
		return delegator;
	}
	
	public static interface FluidContainerScreenDelegator {
		
		void renderLabels(class_332 guiGraphics, int mouseX, int mouseY);
		
		void renderTooltip(class_332 guiGraphics, int mouseX, int mouseY);
		
		boolean mouseClicked(double mouseX, double mouseY, int button);
		
		interface Factory {
			
			Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
			
			<T extends class_1703> FluidContainerScreenDelegator create(FluidContainerMenuScreen<T> menu);
		}
	}
}
