package info.u_team.u_team_core.item.tier;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1856;
import net.minecraft.class_2248;
import net.minecraft.class_6862;
import com.google.common.base.Suppliers;

import info.u_team.u_team_core.api.item.ExtendedTier;

public class UExtendedTier implements ExtendedTier {
	
	private final Map<Tools, Float> attackDamage;
	private final Map<Tools, Float> attackSpeed;
	private final class_6862<class_2248> incorrectBlocksForDrops;
	private final int uses;
	private final float speed;
	private final float attackDamageBonus;
	private final int enchantmentValue;
	private final Supplier<class_1856> repairIngredient;
	
	public UExtendedTier(Map<Tools, Float> attackDamage, Map<Tools, Float> attackSpeed, class_6862<class_2248> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, Supplier<class_1856> repairIngredient) {
		this.attackDamage = new EnumMap<>(Tools.class);
		this.attackDamage.putAll(attackDamage);
		this.attackSpeed = new EnumMap<>(Tools.class);
		this.attackSpeed.putAll(attackSpeed);
		this.incorrectBlocksForDrops = incorrectBlocksForDrops;
		this.uses = uses;
		this.speed = speed;
		this.attackDamageBonus = attackDamageBonus;
		this.enchantmentValue = enchantmentValue;
		this.repairIngredient = Suppliers.memoize(repairIngredient::get);
	}
	
	@Override
	public int method_8025() {
		return uses;
	}
	
	@Override
	public float method_8027() {
		return speed;
	}
	
	@Override
	public float method_8028() {
		return attackDamageBonus;
	}
	
	@Override
	public class_6862<class_2248> method_58419() {
		return incorrectBlocksForDrops;
	}
	
	@Override
	public int method_8026() {
		return enchantmentValue;
	}
	
	@Override
	public class_1856 method_8023() {
		return repairIngredient.get();
	}
	
	@Override
	public float getAttackDamage(Tools tools) {
		return attackDamage.getOrDefault(tools, -1000F);
	}
	
	@Override
	public float getAttackSpeed(Tools tools) {
		return attackSpeed.getOrDefault(tools, -1000F);
	}
	
}
