package info.u_team.u_team_core.intern.network;

import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.menutype.UMenuType;
import info.u_team.u_team_core.util.CastUtil;
import info.u_team.u_team_core.util.RegistryUtil;
import io.netty.buffer.Unpooled;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_3929.class_3930;
import net.minecraft.class_3936;
import net.minecraft.class_437;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record OpenMenuScreenMessage(int containerId, class_3917<?> type, class_2561 title, byte[] extraData) {
	
	public static final class_9139<class_9129, OpenMenuScreenMessage> STREAM_CODEC = class_9139.method_56905( //
			class_9135.field_48550, OpenMenuScreenMessage::containerId, //
			class_9135.method_56365(class_7924.field_41207), OpenMenuScreenMessage::type, //
			class_8824.field_49666, OpenMenuScreenMessage::title, //
			class_9135.field_48987, OpenMenuScreenMessage::extraData, //
			OpenMenuScreenMessage::new);
	
	public static void handle(OpenMenuScreenMessage message, NetworkContext context) {
		context.executeOnMainThread(() -> {
			final class_310 minecraft = class_310.method_1551();
			final class_1661 playerInventory = minecraft.field_1724.method_31548();
			final int containerId = message.containerId;
			final class_3917<?> type = message.type;
			final class_2561 title = message.title;
			final class_2540 extraData = new class_2540(Unpooled.wrappedBuffer(message.extraData));
			
			try {
				if (message.type == null) {
					class_3929.field_17408.warn("Trying to open invalid screen with name: {}", title.getString());
					return;
				}
				final class_3930<class_1703, ?> constructor = CastUtil.uncheckedCast(class_3929.method_17540(type));
				if (constructor == null) {
					class_3929.field_17408.warn("Failed to create screen for menu type: {}", RegistryUtil.getBuiltInRegistry(class_7924.field_41207).method_10221(type));
					return;
				}
				
				final class_1703 menu;
				if (type instanceof final UMenuType<?> uType) {
					menu = uType.createWithExtraData(containerId, playerInventory, extraData);
				} else {
					menu = type.method_17434(containerId, playerInventory);
				}
				
				final class_437 screen = constructor.create(menu, playerInventory, title);
				if (!(screen instanceof final class_3936<?> menuAccess)) {
					class_3929.field_17408.warn("Trying to open invalid screen that does not implement MenuAccess with name: {}", title.getString());
					return;
				}
				
				minecraft.field_1724.field_7512 = menuAccess.method_17577();
				minecraft.method_1507(screen);
			} finally {
				extraData.release();
			}
		});
	}
	
}
