package info.u_team.u_team_core.intern.network;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2540;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import info.u_team.u_team_core.api.network.NetworkContext;
import info.u_team.u_team_core.api.network.NetworkEnvironment;
import info.u_team.u_team_core.menu.UContainerMenu;
import io.netty.buffer.Unpooled;

public record DataHolderMenuMessage(int containerId, int index, byte[] dataHolderBuffer) {
	
	public static final class_9139<class_9129, DataHolderMenuMessage> STREAM_CODEC = class_9139.method_56436( //
			class_9135.field_48550, DataHolderMenuMessage::containerId, //
			class_9135.field_48550, DataHolderMenuMessage::index, //
			class_9135.field_48987, DataHolderMenuMessage::dataHolderBuffer, //
			DataHolderMenuMessage::new);
	
	public static void handle(DataHolderMenuMessage message, NetworkContext context) {
		context.executeOnMainThread(() -> {
			final class_1657 player = context.getPlayer();
			if (player != null) {
				updateDataHolder(player.field_7512, context.getEnvironment(), message);
			}
		});
	}
	
	private static void updateDataHolder(class_1703 menuToTest, NetworkEnvironment environment, DataHolderMenuMessage message) {
		testContainerMenu(menuToTest, message.containerId).ifPresent(menu -> {
			final class_2540 buffer = new class_2540(Unpooled.wrappedBuffer(message.dataHolderBuffer));
			try {
				menu.setDataHolder(environment, message.index, buffer);
			} finally {
				buffer.release();
			}
		});
	}
	
	private static Optional<UContainerMenu> testContainerMenu(class_1703 menu, int containerId) {
		if (menu instanceof final UContainerMenu uContainer && menu.field_7763 == containerId) {
			return Optional.of(uContainer);
		}
		return Optional.empty();
	}
}
