package info.u_team.u_team_core.impl.common;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1928;
import info.u_team.u_team_core.api.registry.GameRuleRegister;
import info.u_team.u_team_core.api.registry.LazyEntry;
import info.u_team.u_team_core.util.CastUtil;

public abstract class CommonGameRuleRegister implements GameRuleRegister {
	
	protected final Map<GameRuleLazyEntry<?>, GameRuleData<?>> entries;
	
	protected CommonGameRuleRegister() {
		entries = new LinkedHashMap<>();
	}
	
	@Override
	public <T extends class_1928.class_4315<T>> LazyEntry<class_1928.class_4313<T>> register(String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type) {
		final GameRuleLazyEntry<T> entry = new GameRuleLazyEntry<>();
		entries.put(entry, new GameRuleData<>(name, category, type));
		return entry;
	}
	
	@Override
	public Collection<LazyEntry<class_1928.class_4313<?>>> getEntries() {
		return CastUtil.uncheckedCast(entries.keySet());
	}
	
	protected void registerEntries() {
		for (final Entry<GameRuleLazyEntry<?>, GameRuleData<?>> entry : entries.entrySet()) {
			final GameRuleLazyEntry<?> registryEntry = entry.getKey();
			
			final GameRuleData<?> data = entry.getValue();
			final class_1928.class_4313<?> key = class_1928.method_8359(data.name, data.category, data.type.get());
			
			registryEntry.updateReference(key);
		}
	}
	
	protected record GameRuleData<T extends class_1928.class_4315<T>>(String name, class_1928.class_5198 category, Supplier<? extends class_1928.class_4314<T>> type) {
	}
	
	public static class GameRuleLazyEntry<T extends class_1928.class_4315<T>> implements LazyEntry<class_1928.class_4313<T>> {
		
		private class_1928.class_4313<T> value;
		
		GameRuleLazyEntry() {
		}
		
		void updateReference(class_1928.class_4313<?> ruleKey) {
			value = CastUtil.uncheckedCast(ruleKey);
		}
		
		@Override
		public class_1928.class_4313<T> get() {
			Objects.requireNonNull(value, () -> "Gamerule not present");
			return value;
		}
		
		@Override
		public boolean isPresent() {
			return value != null;
		}
	}
	
}
