package info.u_team.u_team_core.gui.elements;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1109;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import info.u_team.u_team_core.util.RGBA;

public class ProgressBar implements class_364, class_4068 {
	
	protected Supplier<Double> progress;
	protected Consumer<Double> click;
	
	protected int width = 200;
	protected int height = 5;
	protected int x;
	protected int y;
	
	protected RGBA backgroundColor;
	protected RGBA progressColor;
	
	protected boolean enabled = true;
	protected boolean visible = true;
	
	protected boolean hovered;
	protected boolean focused;
	
	public ProgressBar(int x, int y, int width, int height, RGBA backgroundColor, RGBA progressColor, Supplier<Double> progress, Consumer<Double> click) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
		this.backgroundColor = backgroundColor;
		this.progressColor = progressColor;
		this.progress = progress;
		this.click = click;
	}
	
	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		if (visible) {
			hovered = mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
			
			guiGraphics.method_25294(x, y, x + width, y + height, backgroundColor.getColorARGB());
			guiGraphics.method_25294(x, y, (int) (x + (progress.get() * width)), y + height, progressColor.getColorARGB());
		}
	}
	
	public void onClick(double mouseX, double mouseY) {
		if (click != null) {
			click.accept((mouseX - x) / width);
		}
	}
	
	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (button == 0) {
			if (isPressable(mouseX, mouseY)) {
				playPressSound(class_310.method_1551().method_1483());
				onClick(mouseX, mouseY);
				return true;
			}
		}
		return false;
	}
	
	protected boolean isPressable(double mouseX, double mouseY) {
		return enabled && visible && mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
	}
	
	public void playPressSound(class_1144 soundHandler) {
		soundHandler.method_4873(class_1109.method_47978(class_3417.field_15015, 1.0F));
	}
	
	public void setProgressSupplier(Supplier<Double> progress) {
		this.progress = progress;
	}
	
	public double getProgress() {
		return progress.get();
	}
	
	public int getWidth() {
		return width;
	}
	
	public void setWidth(int width) {
		this.width = width;
	}
	
	public int getHeight() {
		return height;
	}
	
	public void setHeight(int height) {
		this.height = height;
	}
	
	public int getX() {
		return x;
	}
	
	public void setX(int x) {
		this.x = x;
	}
	
	public int getY() {
		return y;
	}
	
	public void setY(int y) {
		this.y = y;
	}
	
	public boolean isEnabled() {
		return enabled;
	}
	
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	
	public boolean isVisible() {
		return visible;
	}
	
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
	
	public boolean isHovered() {
		return hovered;
	}
	
	public RGBA getBackgroundColor() {
		return backgroundColor;
	}
	
	public void setBackgroundColor(RGBA backGroundColor) {
		backgroundColor = backGroundColor;
	}
	
	public RGBA getProgressColor() {
		return progressColor;
	}
	
	public void setProgressColor(RGBA progressColor) {
		this.progressColor = progressColor;
	}
	
	public void setClick(Consumer<Double> click) {
		this.click = click;
	}
	
	@Override
	public void method_25365(boolean focused) {
		this.focused = focused;
	}
	
	@Override
	public boolean method_25370() {
		return focused;
	}
	
}
