package info.u_team.u_team_core.gui.elements;

import info.u_team.u_team_core.util.RGBA;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class ImageToggleButton extends ImageButton {
	
	protected class_2960 toggleImage;
	
	protected RGBA toggleImageColor;
	
	protected boolean toggled;
	
	public ImageToggleButton(int x, int y, int width, int height, class_2960 image, class_2960 toggleImage, boolean toggled) {
		this(x, y, width, height, image, toggleImage, toggled, EMTPY_PRESSABLE);
	}
	
	public ImageToggleButton(int x, int y, int width, int height, class_2960 image, class_2960 toggleImage, boolean toggled, class_4241 pessable) {
		super(x, y, width, height, image, pessable);
		this.toggleImage = toggleImage;
		toggleImageColor = WHITE;
		this.toggled = toggled;
	}
	
	public class_2960 getToggleImage() {
		return toggleImage;
	}
	
	public void setToggleImage(class_2960 toggleImage) {
		this.toggleImage = toggleImage;
	}
	
	public RGBA getToggleImageColor() {
		return toggleImageColor;
	}
	
	public void setToggleImageColor(RGBA toggleImageColor) {
		this.toggleImageColor = toggleImageColor;
	}
	
	public boolean isToggled() {
		return toggled;
	}
	
	public void setToggled(boolean toggled) {
		this.toggled = toggled;
	}
	
	public void toggle() {
		toggled = !toggled;
	}
	
	@Override
	public void method_25306() {
		toggle();
		super.method_25306();
	}
	
	@Override
	public class_2960 getCurrentImage(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return toggled ? toggleImage : image;
	}
	
	@Override
	public RGBA getCurrentImageColor(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		return toggled ? toggleImageColor : imageColor;
	}
}
