package info.u_team.u_team_core.api.registry;

import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_7157;
import com.mojang.brigadier.CommandDispatcher;

import info.u_team.u_team_core.util.ServiceUtil;

public interface CommandRegister {
	
	static CommandRegister create() {
		return Factory.INSTANCE.create();
	}
	
	void register(Consumer<CommandHandler> consumer);
	
	void register();
	
	static record CommandHandler(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
	}
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		CommandRegister create();
	}
}
