package info.u_team.u_team_core.api.network;

import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import info.u_team.u_team_core.util.ServiceUtil;

public interface NetworkHandler {
	
	static NetworkHandler create(class_2960 channel, int protocolVersion) {
		return Factory.INSTANCE.create(channel, protocolVersion);
	}
	
	default <M> NetworkMessage<M> register(int id, NetworkHandlerEnvironment handlerEnvironment, class_9139<? super class_9129, M> streamCodec, BiConsumer<M, NetworkContext> handler) {
		return register(id, NetworkPayload.of(handlerEnvironment, streamCodec, handler));
	}
	
	default <M> NetworkMessage<M> register(int index, NetworkPayload<M> payload) {
		return register(Integer.toString(index), payload);
	}
	
	default <M> NetworkMessage<M> register(String id, NetworkHandlerEnvironment handlerEnvironment, class_9139<? super class_9129, M> streamCodec, BiConsumer<M, NetworkContext> handler) {
		return register(id, NetworkPayload.of(handlerEnvironment, streamCodec, handler));
	}
	
	<M> NetworkMessage<M> register(String id, NetworkPayload<M> payload);
	
	void register();
	
	class_2960 getNetworkId();
	
	int getProtocolVersion();
	
	interface Factory {
		
		Factory INSTANCE = ServiceUtil.loadOne(Factory.class);
		
		NetworkHandler create(class_2960 channel, int protocolVersion);
	}
}
