package info.u_team.u_team_core.menu;

import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import info.u_team.u_team_core.api.menu.ItemSlotCreator;

/**
 * Enhanced version of {@link class_1703} with the benefit that the player that opened the container is known
 * and a method is called when the container is opened on the logical server. Furthermore adds some convenience methods
 * to add multiple slots.
 *
 * @author HyCraftHD
 */
public abstract class UAbstractContainerMenu extends class_1703 {
	
	private class_3222 synchronizerPlayer;
	
	/**
	 * Creates a container menu. Must be implemented by a sub class to be used.
	 *
	 * @param menuType Menu type
	 * @param containerId Container id
	 */
	protected UAbstractContainerMenu(class_3917<?> menuType, int containerId) {
		super(menuType, containerId);
	}
	
	/**
	 * Do not call your self. Will be called from an asm hook inside {@link class_3222#method_14235(class_1703)}.
	 * This method sets player that has the container opened. Will be called before
	 * {@link #method_34248(net.minecraft.class_5916)} so that method can be used for
	 * synchronizing already.
	 *
	 * @param player Server player that opened the container
	 */
	public final void setSynchronizerPlayer(class_3222 player) {
		synchronizerPlayer = player;
	}
	
	/**
	 * Returns the player that opened the container and should be used for synchronizing purposes.
	 *
	 * @return Server player that opened the container
	 */
	public final class_3222 getSynchronizerPlayer() {
		return synchronizerPlayer;
	}
	
	/**
	 * Will be called immediately after the {@link #setSynchronizerPlayer(class_3222)}.
	 *
	 * @param player Server player that opened the container
	 */
	public void initMenu(class_3222 player) {
	}
	
	/**
	 * Returns the last slot list that is used to check if a stack has changed since last check. The list should not be
	 * modified manually.
	 *
	 * @return List with item stacks
	 */
	protected List<class_1799> getLastSlots() {
		return field_7764;
	}
	
	/**
	 * This methods adds a player inventory to the container.
	 *
	 * @param playerInventory Player inventory
	 * @param x Start x
	 * @param y Start y
	 */
	protected void addPlayerInventory(class_1661 playerInventory, int x, int y) {
		for (int height = 0; height < 4; height++) {
			for (int width = 0; width < 9; width++) {
				if (height == 3) {
					method_7621(new class_1735(playerInventory, width, width * 18 + x, height * 18 + 4 + y));
					continue;
				}
				method_7621(new class_1735(playerInventory, width + height * 9 + 9, width * 18 + x, height * 18 + y));
			}
		}
	}
	
	/**
	 * This methods can add any {@link ItemSlotCreator} to this menu.
	 *
	 * @param slotCreator Slot creator
	 * @param rows Slot rows
	 * @param columns Slot columns
	 * @param x Start x
	 * @param y Start y
	 */
	protected void addSlots(ItemSlotCreator slotCreator, int rows, int columns, int x, int y) {
		addSlots(slotCreator, 0, rows, columns, x, y);
	}
	
	/**
	 * This methods can add any {@link ItemSlotCreator} to this menu.
	 *
	 * @param slotCreator Slot creator
	 * @param startIndex Start index of inventory
	 * @param rows Slot rows
	 * @param columns Slot columns
	 * @param x Start x
	 * @param y Start y
	 */
	protected void addSlots(ItemSlotCreator slotCreator, int startIndex, int rows, int columns, int x, int y) {
		for (int height = 0; height < rows; height++) {
			for (int width = 0; width < columns; width++) {
				method_7621(slotCreator.createSlot(startIndex + (width + height * columns), width * 18 + x, height * 18 + y));
			}
		}
	}
}
