package info.u_team.u_team_core.impl.common;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5614;
import net.minecraft.class_5617;
import info.u_team.u_team_core.api.registry.client.EntityRendererRegister;

public abstract class CommonEntityRendererRegister implements EntityRendererRegister {
	
	protected final Map<Supplier<? extends class_1299<?>>, class_5617<?>> entityProviders;
	protected final Map<Supplier<? extends class_2591<?>>, class_5614<?>> blockEntityProviders;
	
	protected CommonEntityRendererRegister() {
		entityProviders = new HashMap<>();
		blockEntityProviders = new HashMap<>();
	}
	
	@Override
	public <T extends class_1297> void register(Supplier<? extends class_1299<? extends T>> supplier, class_5617<T> provider) {
		entityProviders.put(supplier, provider);
	}
	
	@Override
	public <T extends class_2586> void register(Supplier<? extends class_2591<? extends T>> supplier, class_5614<T> provider) {
		blockEntityProviders.put(supplier, provider);
	}
	
}
