package info.u_team.u_team_core.impl.common;

import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import info.u_team.u_team_core.api.registry.BlockRegistryEntry;
import info.u_team.u_team_core.api.registry.RegistryEntry;

public abstract class CommonBlockRegistryEntry<B extends class_2248, I extends class_1792, RB extends RegistryEntry<B>, RI extends RegistryEntry<I>> implements BlockRegistryEntry<B, I> {
	
	private final RB block;
	private final RI item;
	
	protected CommonBlockRegistryEntry(RB block, RI item) {
		this.block = block;
		this.item = item;
	}
	
	@Override
	public B get() {
		return block.get();
	}
	
	@Override
	public class_2960 getId() {
		return block.getId();
	}
	
	@Override
	public class_5321<B> getKey() {
		return block.getKey();
	}
	
	@Override
	public Optional<class_6880<B>> getHolder() {
		return block.getHolder();
	}
	
	@Override
	public boolean isPresent() {
		return block.isPresent();
	}
	
	@Override
	public I getItem() {
		return item.get();
	}
	
	@Override
	public class_2960 getItemId() {
		return item.getId();
	}
	
	@Override
	public class_5321<I> getItemKey() {
		return item.getKey();
	}
	
	@Override
	public Optional<class_6880<I>> getItemHolder() {
		return item.getHolder();
	}
	
	@Override
	public boolean isItemPresent() {
		return item.isPresent();
	}
	
	@Override
	public RegistryEntry<I> getItemRegistryEntry() {
		return item;
	}
	
	public RB getBlockEntry() {
		return block;
	}
	
	public RI getItemEntry() {
		return item;
	}
	
}
